<?php

include_once(ABSPATH . 'wp-admin/includes/plugin.php');

class Dclwpnext_paction {

    private $_p_action_post_key = '_nitro_p_action';
    private $_p_info_post_key = '_nitro_p_info';
    private $_p_update_post_key = '_nitro_p_update';

    function __construct() {
        //plugin activation or deactivation action
        add_action('init', array($this, 'nitro_plugin_action'));
        //plugin info action
        add_action('init', array($this, 'nitro_plugin_info'));
        //plugin update or installation action
        add_action('init', array($this, 'nitro_update_plugin'));
    }

    //function to activate, deactivate or delete plugin
    function nitro_plugin_action($args = null) {
        $returnArr = null;
        if ($_POST && isset($_POST[$this->_p_action_post_key])) {
            $args = json_decode(stripslashes(trim($_POST[$this->_p_action_post_key])), true);
            if (is_array($args) && count($args)) {
                foreach ($args as $arg) {
                    $plugin = isset($arg['plugin']) ? $arg['plugin'] : '';
                    if ($plugin) {
                        $pluginPath = ABSPATH . 'wp-content' . DIRECTORY_SEPARATOR . 'plugins' . DIRECTORY_SEPARATOR . $plugin;
                        if (file_exists($pluginPath)) {
                            $action = isset($arg['action']) ? $arg['action'] : '';

                            $isActive = is_plugin_active($plugin);

                            if ($action == 'activate') {
                                if (!$isActive) {
                                    try {
                                        activate_plugin($pluginPath);
                                    } catch (Exception $exc) {
                                        $returnArr[$plugin] = $exc->getTraceAsString();
                                    }
                                    if (is_plugin_active($plugin)) {
                                        $returnArr[$plugin] = 'Activated';
                                    } else {
                                        $returnArr[$plugin] = 'Activation Failed';
                                    }
                                } else {
                                    $returnArr[$plugin] = 'Active';
                                }
                            } elseif ($action == 'deactivate') {
                                if ($isActive) {
                                    try {
                                        deactivate_plugins($pluginPath);
                                    } catch (Exception $exc) {
                                        $returnArr[$plugin] = $exc->getTraceAsString();
                                    }
                                    if (!is_plugin_active($plugin)) {
                                        $returnArr[$plugin] = 'Deactivated';
                                    } else {
                                        $returnArr[$plugin] = 'Deactivation Failed';
                                    }
                                } else {
                                    $returnArr[$plugin] = 'Inactive';
                                }
                            } elseif ($action == 'delete') {
                                $subDir = explode('/', $plugin);
                                if (count($subDir) > 1) {
                                    $pluginSubdirectory = ABSPATH . 'wp-content' . DIRECTORY_SEPARATOR . 'plugins' . DIRECTORY_SEPARATOR . $subDir[0];
                                    if (file_exists($pluginSubdirectory)) {
                                        $deleted = $this->nitro_delete_directory($pluginSubdirectory);
                                        if ($deleted === true) {
                                            $returnArr[$plugin] = 'Deleted';
                                            deactivate_plugins($pluginPath);
                                        } else {
                                            $returnArr[$plugin] = 'Deletion Failed';
                                        }
                                    } else {
                                        $returnArr[$plugin] = 'Not Found';
                                    }
                                } else {
                                    $returnArr[$plugin] = 'Invalid Subdirectory';
                                }
                            }
                        } else {
                            $returnArr[$plugin] = 'Not Found';
                        }
                    } else {
                        return 'Invalid Plugin';
                    }
                }
            }
            echo json_encode($returnArr);
            exit;
        }
    }

    //function to get plugin information
    function nitro_plugin_info($args = null) {
        $returnArr = null;
        if ($_POST && isset($_POST[$this->_p_info_post_key])) {
            $args = json_decode(stripslashes(trim($_POST[$this->_p_info_post_key])), true);
            if (is_array($args) && count($args)) {
                foreach ($args as $arg) {
                    $plugin = $arg['plugin'];
                    $pluginPath = ABSPATH . 'wp-content' . DIRECTORY_SEPARATOR . 'plugins' . DIRECTORY_SEPARATOR . $plugin;
                    $returnArr[$plugin] = array();
                    $pluginData = get_plugin_data($pluginPath);
                    if ($pluginData['Name']) {
                        $returnArr[$plugin] = $pluginData;
                        $returnArr[$plugin]['is_active'] = 0;
                        if (is_plugin_active($plugin)) {
                            $returnArr[$plugin]['is_active'] = 1;
                        }
                    } else {
                        $returnArr[$plugin] = 'Not Found';
                    }
                }
            }
            echo json_encode($returnArr);
            exit;
        }
    }

    //function to install or update plugin
    function nitro_update_plugin($args = null) {
        $returnArr = null;
        if ($_POST && isset($_POST[$this->_p_update_post_key])) {
            $args = json_decode(stripslashes(trim($_POST[$this->_p_update_post_key])), true);
            if (is_array($args) && count($args)) {
                foreach ($args as $arg) {
                    $plugin = $arg['plugin'];
                    $pluginPath = ABSPATH . 'wp-content' . DIRECTORY_SEPARATOR . 'plugins' . DIRECTORY_SEPARATOR . $plugin;

                    $pluginDirectoryPath = ABSPATH . 'wp-content' . DIRECTORY_SEPARATOR . 'plugins' . DIRECTORY_SEPARATOR;
                    $arg['plugin_directory_path'] = $pluginDirectoryPath;

                    if (is_plugin_active($plugin)) {
                        $pluginData = get_plugin_data($pluginPath);
                        if ($pluginData['Version'] < $arg['latest_version']) {
                            $installed = $this->nitro_get_plugins($arg);
                            if ($installed) {
                                try {
                                    deactivate_plugins($pluginPath);
                                } catch (Exception $exc) {
                                    $returnArr[$plugin] = $exc->getTraceAsString();
                                }
                                try {
                                    activate_plugin($pluginPath);
                                } catch (Exception $exc) {
                                    $returnArr[$plugin] = $exc->getTraceAsString();
                                }
                                if (is_plugin_active($plugin)) {
                                    $returnArr[$plugin] = 'Updated';
                                }
                            }
                        } else {
                            $returnArr[$plugin] = 'Latest';
                        }
                    } else {
                        $installed = $this->nitro_get_plugins($arg);
                        if ($installed) {
                            try {
                                if (activate_plugin($pluginPath) === false) {
                                    $returnArr[$plugin] = 'Installed & activated';
                                }
                            } catch (Exception $exc) {
                                $returnArr[$plugin] = $exc->getTraceAsString();
                            }
                            if (is_plugin_active($plugin)) {
                                $returnArr[$plugin] = 'Installed';
                            }
                        }
                    }
                }
            }
            echo json_encode($returnArr);
            exit;
        }
    }

    /* install and update plugin */

    //function to process plugin download
    function nitro_get_plugins($pluginInfo) {

        $pluginSubdirectory = $pluginInfo['plugin_directory_path'];
        $destination = $pluginSubdirectory . $pluginInfo['name'] . '.zip';

        $downloaded = $this->nitro_plugin_download($pluginInfo['update_url'], $destination);

        if ($downloaded) {
            $args = array(
                'path' => $pluginInfo['plugin_directory_path'],
                'preserve_zip' => isset($pluginInfo['preserve_zip']) ? $pluginInfo['preserve_zip'] : false
            );
            return $this->nitro_plugin_unpack($args, $args['path'] . $pluginInfo['name'] . '.zip');
        }
    }

// function to download plugin
    function nitro_plugin_download($url, $path) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $data = curl_exec($ch);
        curl_close($ch);
        if (file_put_contents($path, $data))
            return true;
        else
            return false;
    }

// function to unpack downloaded plugin
    function nitro_plugin_unpack($args, $target) {
        if ($zip = zip_open($target)) {
            while ($entry = zip_read($zip)) {
                $is_file = substr(zip_entry_name($entry), -1) == '/' ? false : true;
                $file_path = $args['path'] . zip_entry_name($entry);
                if ($is_file) {
                    if (zip_entry_open($zip, $entry, "r")) {
                        $fstream = zip_entry_read($entry, zip_entry_filesize($entry));
                        file_put_contents($file_path, $fstream);
                        chmod($file_path, 0777);
                        //echo "save: ".$file_path."<br />";
                    }
                    zip_entry_close($entry);
                } else {
                    if (zip_entry_name($entry)) {
                        @mkdir($file_path);
                        chmod($file_path, 0777);
                        //echo "create: ".$file_path."<br />";
                    }
                }
            }
            zip_close($zip);
            if ($args['preserve_zip'] === false) {
                @unlink($target);
            }
            return true;
        }
        return false;
    }

    //function to delete plugin directory
    function nitro_delete_directory($path) {
        return is_file($path) ?
                @unlink($path) :
                array_map($this->nitro_delete_directory, glob($path . DIRECTORY_SEPARATOR . '*')) == @$this->nitro_rrmdir($path);
    }

    //function for recursive directory deletion
    function nitro_rrmdir($dir) {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir . DIRECTORY_SEPARATOR . $object) == "dir")
                        $this->nitro_rrmdir($dir . DIRECTORY_SEPARATOR . $object);
                    else
                        @unlink($dir . DIRECTORY_SEPARATOR . $object);
                }
            }
            reset($objects);
            return rmdir($dir);
        }
    }

}
