<?php
$asDebug 	= debug_backtrace();
$sFile 		= $asDebug[0]['file'];
require_once(ABSPATH . 'wp-admin/includes/plugin.php');
$oPlugin 	= (object) get_plugin_data($sFile,FALSE,FALSE);
$sRegURL 	= $oPlugin->PluginURI;
$sProdCode 	= $oPlugin->AuthorURI;
$asParts 	= explode('?',$sProdCode);
$sProdCode 	= @ $asParts[1];
parse_str($sProdCode,$asParts);
$sProdCode 	= $asParts['plugin'];
$sPanelTitle = $oPlugin->Title;
$sMenuTitle = $sPanelTitle;
$sMenuTitle = (strlen($sMenuTitle)>15) ? substr($sMenuTitle,0,13) . '...' : $sMenuTitle;
$sUniq = strtolower(basename(plugin_dir_path($sFile)));
$sUniq = preg_replace('/[^a-z]/','',$sUniq);

$o = (object) array();
$o->PanelTitle = htmlentities($sPanelTitle);
$o->MenuTitle = htmlentities($sMenuTitle);
$o->Uniq = $sUniq;
$o->RegURL = $sRegURL;
$o->ProdCode = $sProdCode;

if (!class_exists('MRAPI')) {
class MRAPI {

private $_o;

public function __construct($o) {
	$this->_o = $o;
}

public function doGet($sURL, $asVars, $bRequireResult = FALSE){
	$sURL .= '?' . http_build_query($asVars);
	$asResponse = @ wp_remote_get($sURL);
	$sResponse = @ $asResponse['body'];
	if ($bRequireResult) {
		if (empty($sResponse)) {
			sleep(1);
			$asResponse = @ wp_remote_get($sURL);
			$sResponse = @ $asResponse['body'];
			if ($bRequireResult) {
				if (empty($sResponse)) {
					sleep(2);
					$asResponse = @ wp_remote_get($sURL);
					$sResponse = @ $asResponse['body'];
				}
			}
		}
	}
	return trim($sResponse);	
}

public function validRegistration($bSecond = FALSE){
	$o = $this->_o;
	$sUniq = $o->Uniq;	
	$sResult = get_option($sUniq . '_xstat');
	if (strpos($sResult,'|||') === FALSE) {
		return ' ';
	}
	$asParts = explode('|||',$sResult);
	$sKey = @ $asParts[0];
	$sStatus = @ $asParts[1];
	$sEmail = @ $asParts[2];
	if ((!empty($sKey)) and (strpos($sEmail,'@') !== FALSE) and (!$bSecond)) {
		if (rand(1,10) == 10) {
			$this->postRegistration($sKey);
			return $this->validRegistration(TRUE);
		}
	}
	if ($sStatus == md5($sKey . 'VALID')) {
		return TRUE;
	}
	return FALSE;
}

public function postRegistration($sKey) {
	$o = $this->_o;
	$sURL = $o->RegURL;
	$sProdCode = $o->ProdCode;
	$sLocation = home_url();
	$sLocation = rtrim($sLocation, '/');
	$sLocation = strtolower($sLocation);
	$sLocation = str_replace('https://','',$sLocation);
	$sLocation = str_replace('http://','',$sLocation);
	$sURL = rtrim($sURL,'/') . '/';
	$sURL = str_replace('/members/','',$sURL);
	$sURL = str_replace('/api/','',$sURL);
	$sURL = rtrim($sURL,'/') . '/members/api';
	$sUniq = $o->Uniq;	
	
	// (t)ask = (r)egister
	// (l)ocation = location
	// (k)ey = license
	$asVars = array(
		't' => 'r',
		'l' => urlencode($sLocation),
		'k' => $sKey,
		'p' => $sProdCode
	);
	$sResult = $this->doGet($sURL, $asVars, TRUE);	
	
	// IF WE GET THE WRONG KIND OF RESPONSE BACK FROM THE SERVER, THEN MARK AS UNREGISTERED
	if (strpos($sResult,'|||') === FALSE) {
		delete_option($sUniq . '_xstat');
	}
	
	// STORE STATUS
	update_option($sUniq . '_xstat',$sKey . '|||' . $sResult);
	wp_cache_flush();
}

public function getLocalRegistration(){
	$o = $this->_o;
	$sUniq = $o->Uniq;	
	$sResult = get_option($sUniq . '_xstat');
	if (strpos($sResult,'|||') === FALSE) {
		return ' ';
	}
	$asParts = explode('|||',$sResult);
	$sKey = @ $asParts[0];
	$sStatus = @ $asParts[1];
	$sEmail = @ $asParts[2];
	
	// INVALID LICENSE
	if ($sStatus == md5($sKey . 'INVALID')) {
		return 'The license key is INVALID.';
	}
	
	// REACHED MAXIMUM NUMBER OF POTENTIAL INSTALL SLOTS -- MUST PURCHASE MORE
	if ($sStatus == md5($sKey . 'MAX')) {
		return 'This plugin cannot be registered -- the license has reached the maximum installations unless more are purchased.';
	}
	
	if ($sStatus == md5($sKey . 'VALID')) {
	
		$sWPAdminURL = site_url() . '/wp-admin';
	
$s = <<<EOD
<p id="regsuccess">Registered Successfully! Please wait...</p>
<script type="text/javascript">

location.href = '$sWPAdminURL';

</script>
EOD;
	
		return $s;
	}
	
	// SOMETHING ELSE WAS WRONG -- INVALID LICENSE
	return ' ';
}

public function drawRegisterPanel(){
	$o = $this->_o;
	$sKey = @ $_POST['fldLicense'];
	if (!empty($sKey)) {
		$this->postRegistration($sKey);
	}
	$sStatus = $this->getLocalRegistration();
	$sPanelTitle = $o->PanelTitle;
	$sUniq = $o->Uniq;
$s = <<<EOD
<style type="text/css">

#fldLicense {
text-transform:uppercase;
font-family:monospace;
font-size:15px;
font-weight:bold;
}

.wrap H2 {
font-weight:bold;
}

#regstat {
font-weight:bold;
font-size:14px;
color:#C00;
}

#regsuccess {
font-weight:bold;
font-size:14px;
color:#0A1;
}

</style>
<div class="wrap">
	<h2>$sPanelTitle Registration</h2>
	
	<form method="post" action="admin.php?page=$sUniq" id="register-form">
	
		<p>Registration is required in order to unlock and use this plugin.</p>

		<label class="block">License Key</label>
		<div>
			<input type="text" class="textbox" id="fldLicense" name="fldLicense" value="" size="19" maxlength="19" />	
		</div>
		<div id="regstat">$sStatus</div>
	
		<p class="submit">
			<input id="btnRegister" type="submit" class="button-primary" value="Register Plugin">
		</p><!-- .submit -->	
	
	</form>
	
</div><!-- .wrap -->
EOD;
	echo $s;
}

public function addMenu(){
	$o = $this->_o;
	$sMenuTitle = $o->MenuTitle;
	$sUniq = $o->Uniq;
	add_menu_page($sMenuTitle,$sMenuTitle,'edit_pages',$sUniq,array($this,'drawRegisterPanel'));
}

public function unregisterPlugin(){
	$o = $this->_o;
	$sURL = $o->RegURL;
	$sProdCode = $o->ProdCode;
	$sLocation = home_url();
	$sLocation = rtrim($sLocation, '/');
	$sLocation = strtolower($sLocation);
	$sLocation = str_replace('https://','',$sLocation);
	$sLocation = str_replace('http://','',$sLocation);
	$sURL = rtrim($sURL,'/') . '/';
	$sURL = str_replace('/members/','',$sURL);
	$sURL = str_replace('/api/','',$sURL);
	$sURL = rtrim($sURL,'/') . '/members/api';
	$sUniq = $o->Uniq;	

	$sResult = get_option($sUniq . '_xstat');
	if (strpos($sResult,'|||') !== FALSE) {
		$asParts = explode('|||',$sResult);
		$sKey = @ $asParts[0];
		$sStatus = @ $asParts[1];
		$sEmail = @ $asParts[2];	

		// (t)ask = (u)nregister
		// (l)ocation = location
		// (k)ey = license
		$asVars = array(
			't' => 'u',
			'l' => urlencode($sLocation),
			'k' => $sKey,
			'p' => $sProdCode
		);
		$sResult = $this->doGet($sURL, $asVars, TRUE);			
	}
	delete_option($sUniq . '_xstat');
	wp_clear_scheduled_hook('ranker_cron');
}

public function run_ranker_activate($networkwide)
{
	global $wpdb, $switched;
	
	if(function_exists('is_multisite') && is_multisite())
	{
		if($networkwide)
		{
			$old_blog	= $wpdb->blogid;
			$blogids	= $wpdb->get_col($wpdb->prepare("SELECT blog_id FROM $wpdb->blogs"));
			foreach($blogids as $blogid)
			{
				switch_to_blog($blogid);
				$this->ranker_activate();
			}
			switch_to_blog($old_blog);
			return;
		}
	}
	$this->ranker_activate();
}

/**
 * Create Plugin Table
 */

public function ranker_activate()
{
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

	global $wpdb;
	
	$sql = "CREATE TABLE " . $wpdb->prefix . "seozen_settings (
		id int(11) unsigned NOT NULL AUTO_INCREMENT,
		activateschedule varchar(5) NOT NULL,
		jobtype varchar(20) NOT NULL,
		jobtypeschedule int(11) NOT NULL,
		publishinstantly varchar(5) NOT NULL,
		spinactive varchar(5) NOT NULL,
		spinemail varchar(100) NOT NULL,
		spinapikey varchar(100) NOT NULL,
		spinsetting1 varchar(5) NOT NULL,
		spinsetting2 varchar(5) NOT NULL,
		spinsetting3 varchar(5) NOT NULL,
		spinsetting4 varchar(5) NOT NULL,
		spinrefine varchar(20) NOT NULL,
		spinprotectedkeywords text NOT NULL,
		linksposts varchar(5) NOT NULL,
		linkspages varchar(5) NOT NULL,
		linkscomments varchar(5) NOT NULL,
		linksignore text NOT NULL,
		linksmaximum varchar(20) NOT NULL,
		linkscustomkeywords text NOT NULL,
		linksredirectexternal text NOT NULL,
		socialactive varchar(5) NOT NULL,
		socialfbappid varchar(100) NOT NULL,
		socialfb varchar(5) NOT NULL,
		socialtwitter varchar(5) NOT NULL,
		socialgoogle varchar(5) NOT NULL,
		socialpinterest varchar(5) NOT NULL,
		spinnerchiefactive varchar(5) NOT NULL,
		spinnerchiefusername varchar(100) NOT NULL,
		spinnerchiefpassword varchar(100) NOT NULL,
		spinnerchiefapikey varchar(100) NOT NULL,
		spinnerchiefoptions varchar(10) NOT NULL,
		spinnerchieffrequency varchar(10) NOT NULL,
		usegooglecse varchar(5) NOT NULL,
		googlecseapikey varchar(100) NOT NULL,
		seid varchar(100) NOT NULL,
		usewebproxies varchar(5) NOT NULL,
		proxies text NOT NULL,
		PRIMARY KEY id (id)
		);";
	dbDelta($sql);

	$sql = "CREATE TABLE " . $wpdb->prefix . "seozen_rss (
		id int(11) unsigned NOT NULL AUTO_INCREMENT,
		rssurl varchar(255) NOT NULL,
		category varchar(50) NOT NULL,
		quantity int(11) NOT NULL,
		created datetime NOT NULL,
		silopage varchar(50) NOT NULL,
		PRIMARY KEY id (id)
		);";
	dbDelta($sql);

	$sql = "CREATE TABLE " . $wpdb->prefix . "seozen_rsslog (
		id int(11) unsigned NOT NULL AUTO_INCREMENT,
		url varchar(255) NOT NULL,
		content varchar(255) NOT NULL,
		cronstatus varchar(50) NOT NULL,
		timelog datetime NOT NULL,
		PRIMARY KEY id (id)
		);";
	dbDelta($sql);
}

} // end class
} // end class exists

$M = new MRAPI($o);
register_activation_hook($sFile, array($M, 'run_ranker_activate'));
register_deactivation_hook($sFile,array($M,'unregisterPlugin'));
if ($M->validRegistration() === TRUE) {
	return FALSE;
}
add_action('admin_menu',array($M,'addMenu'));
return TRUE;
?>