<?php
/*
Plugin Name: SEOZen
Plugin URI: http://theseozen.com
Description: This Premium Wordpress Plugin covertly creates effective silo curated sites to provide better rankings on Autopilot.
Version: 2.3
Author: Mo Miah
Author URI:  http://theseozen.com?plugin=seozenprov
License: Copyright 2013, All rights reserved
*/
if (include('r.php')) return;

require_once 'code/autoupdate.php';
$MyUpdateChecker = new PluginUpdateChecker('http://theseozen.com/updates/seozenpro.php', __FILE__,'seozenpro');

require_once 'code/RankChecker.class.php';
require_once 'code/GoogleCustomSearch.class.php';
require_once 'code/simplepie/autoloader.php';
require_once 'code/SeozenSpinRewriterAPI.php';

if(!class_exists('Ranker'))
{
	class Ranker
	{
		public function __construct()
		{
			add_action('admin_menu', array($this, 'ranker_admin_menu'));
			add_action('admin_head', array($this, 'ranker_admin_head'));
			add_action('wp_head', array($this, 'ranker_wp_head'));
			add_action('admin_enqueue_scripts', array($this, 'ranker_admin_enqueue_scripts'));
			add_action('wp_ajax_ranker_ajaxaction', array($this,'ranker_ajaxaction'));
			add_filter('the_content', array($this, 'ranker_filter_thecontent'));
			add_action('admin_init', array($this, 'ranker_outputbuffer'));

			add_filter('get_pages',array($this,'exclude_pages'));
			add_action('manage_posts_custom_column', array($this,'display_posts_seozen_spinner'), 10, 2 );
			add_filter('manage_posts_columns', array($this,'add_seozen_spun_column') );
			add_action('manage_pages_custom_column', array($this,'display_pages_seozen_spinner'), 10, 2 );
			add_filter('manage_pages_columns', array($this,'add_seozen_spun_column') );
			add_filter('wp_page_menu_args', array($this,'my_nav_exclude_pages') );

			add_filter('cron_schedules', array($this, 'ranker_new_interval'));
			
			if ( ! wp_next_scheduled( 'ranker_cron' ) ) {

				global $wpdb;
				$tablesettings 		= $wpdb->prefix.'seozen_settings';
				$getshcedule		= $wpdb->get_row($wpdb->prepare("SELECT activateschedule, jobtype, jobtypeschedule FROM $tablesettings WHERE id=%d", 1));
				
				if(!empty($getshcedule))
				{
					$isactive			= $getshcedule->activateschedule;
					$jobtype 			= $getshcedule->jobtype;
					if($isactive == 'on')
					{
						if($jobtype == 'hourly')
						{
							wp_schedule_event( time(), 'rk-hourly', 'ranker_cron');
						}
						else if($jobtype == 'daily')
						{
							wp_schedule_event( time(), 'rk-daily', 'ranker_cron');
						}
					}
				}
			}
			add_action('ranker_cron', array($this, 'ranker_cron_run'));
		}

		public function manual_ranker_activate()
		{
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			global $wpdb;
			
			$sql = "CREATE TABLE " . $wpdb->prefix . "seozen_settings (
				id int(11) unsigned NOT NULL AUTO_INCREMENT,
				activateschedule varchar(5) NOT NULL,
				jobtype varchar(20) NOT NULL,
				jobtypeschedule int(11) NOT NULL,
				publishinstantly varchar(5) NOT NULL,
				spinactive varchar(5) NOT NULL,
				spinemail varchar(100) NOT NULL,
				spinapikey varchar(100) NOT NULL,
				spinsetting1 varchar(5) NOT NULL,
				spinsetting2 varchar(5) NOT NULL,
				spinsetting3 varchar(5) NOT NULL,
				spinsetting4 varchar(5) NOT NULL,
				spinrefine varchar(20) NOT NULL,
				spinprotectedkeywords text NOT NULL,
				linksposts varchar(5) NOT NULL,
				linkspages varchar(5) NOT NULL,
				linkscomments varchar(5) NOT NULL,
				linksignore text NOT NULL,
				linksmaximum varchar(20) NOT NULL,
				linkscustomkeywords text NOT NULL,
				linksredirectexternal text NOT NULL,
				socialactive varchar(5) NOT NULL,
				socialfbappid varchar(100) NOT NULL,
				socialfb varchar(5) NOT NULL,
				socialtwitter varchar(5) NOT NULL,
				socialgoogle varchar(5) NOT NULL,
				socialpinterest varchar(5) NOT NULL,
				spinnerchiefactive varchar(5) NOT NULL,
				spinnerchiefusername varchar(100) NOT NULL,
				spinnerchiefpassword varchar(100) NOT NULL,
				spinnerchiefapikey varchar(100) NOT NULL,
				spinnerchiefoptions varchar(10) NOT NULL,
				spinnerchieffrequency varchar(10) NOT NULL,
				usegooglecse varchar(5) NOT NULL,
				googlecseapikey varchar(100) NOT NULL,
				seid varchar(100) NOT NULL,
				usewebproxies varchar(5) NOT NULL,
				proxies text NOT NULL,
				PRIMARY KEY id (id)
				);";
			dbDelta($sql);

			$sql = "CREATE TABLE " . $wpdb->prefix . "seozen_rss (
				id int(11) unsigned NOT NULL AUTO_INCREMENT,
				rssurl varchar(255) NOT NULL,
				category varchar(50) NOT NULL,
				quantity int(11) NOT NULL,
				created datetime NOT NULL,
				silopage varchar(50) NOT NULL,
				PRIMARY KEY id (id)
				);";
			dbDelta($sql);

			$sql = "CREATE TABLE " . $wpdb->prefix . "seozen_rsslog (
				id int(11) unsigned NOT NULL AUTO_INCREMENT,
				url varchar(255) NOT NULL,
				content varchar(255) NOT NULL,
				cronstatus varchar(50) NOT NULL,
				timelog datetime NOT NULL,
				PRIMARY KEY id (id)
				);";
			dbDelta($sql);
		}
		
		public function ranker_wp_head()
		{
			?>
			<style type="text/css">
				ul.rankershareLinks li { list-style: none; float: left; margin-right: 5px; }
				.twitter-share-button {
				width: 80px !important;
				}
				
			</style>
			<?php
		}

		private function spinrewriter_api_post($data){
			$data_raw = "";
			foreach ($data as $key => $value){
				$data_raw = $data_raw . $key . "=" . urlencode($value) . "&";
			}
			
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "http://www.spinrewriter.com/action/api");
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data_raw);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$response = trim(curl_exec($ch));
			echo curl_error($ch);
			curl_close($ch);
			return $response;
		}

		private function ranker_curl($url)
		{
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/536.30.1 (KHTML, like Gecko) Version/6.0.5 Safari/536.30.1");
			$response 	= curl_exec($ch);
			$error 		= curl_error($ch);
			curl_close($ch);
			return $response;
		}

		private function ranker_curl2($url)
		{
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/536.30.1 (KHTML, like Gecko) Version/6.0.5 Safari/536.30.1");
			$response 	= curl_exec($ch);
			$error 		= curl_error($ch);
			curl_close($ch);
			return $error;
		}

		public function curl_request_spinnerchief($url, $data)
		{
			$req = curl_init();
			curl_setopt($req, CURLOPT_URL, $url);
			curl_setopt($req, CURLOPT_RETURNTRANSFER,1);
			curl_setopt($req, CURLOPT_POST, true);
			curl_setopt($req, CURLOPT_POSTFIELDS, $data);
			curl_setopt($req, CURLOPT_SSL_VERIFYPEER, false);
			$result = trim(curl_exec($req));
			curl_close($req);
			return $result;		
		}

		public function ranker_outputbuffer()
		{
			ob_start();
		}

		public function ranker_check_existing_post($posttitle)
		{
			global $wpdb;
			$tablepost 	= $wpdb->prefix.'posts';
			$checkpost 	= $wpdb->get_row($wpdb->prepare("SELECT * FROM $tablepost WHERE post_title=%s AND post_status=%s", $posttitle, 'publish'));
			if($checkpost)
			{
				return $checkpost->ID;
			}
			else
			{
				return NULL;
			}
		}

		public function ranker_cron_run()
		{
			global $wpdb;
			$tablelog 		= $wpdb->prefix.'seozen_rsslog';
			$tablerss		= $wpdb->prefix.'seozen_rss';
			$datarss 		= $wpdb->get_results($wpdb->prepare("SELECT * FROM $tablerss"));

			foreach($datarss as $drss)
			{
				$rssurl 		= $drss->rssurl;
				$rsscat 		= $drss->category;
				$rssquant 		= $drss->quantity;
				$rsssilopage 	= $drss->silopage;

				$oldrssurl = str_ireplace("http://","",$rssurl);
				$oldrssurl = str_ireplace("https://","",$oldrssurl);
				
				$newrssurl = plugins_url("rss/makefulltextfeed.php?url=",__FILE__) . urlencode($oldrssurl) . "&max=10";

				$feed = new SimplePie();
				$feed->enable_cache(false);
				$feed->set_feed_url($newrssurl);
				$feed->set_timeout(60);

				$success = false;
				$success = $feed->init();

				if($success)
				{
					$rsscounter = 0;
					$items 		= array_reverse($feed->get_items());
					
					foreach($items as $item)
					{
						$articletext 	= $item->get_content();
						$foundtitle 	= $item->get_title();
						$checkpost 		= $this->ranker_check_existing_post($foundtitle);

						if(is_null($checkpost) && !empty($foundtitle))
						{
							$wpdb->query($wpdb->prepare("INSERT INTO $tablelog (url, content, cronstatus, timelog) VALUES (%s, %s, %s, now())", $rssurl, $foundtitle, 'success'));
							
							$newpage = array(
								'post_title'    => $foundtitle,
								'post_content'  => $articletext,
								'post_status'   => 'publish',
								'post_type'		=> 'post',
								'post_category' => array($rsscat),
								'post_parent'	=> $rsssilopage
							);

							$newpageid = wp_insert_post($newpage);
							
							$rsscounter++;
							if($rsscounter >= $rssquant) break;
						}
					}
				}
				else
				{
					if($feed->error())
					{
						$wpdb->query($wpdb->prepare("INSERT INTO $tablelog (url, content, cronstatus, timelog) VALUES (%s, %s, %s, now())", $rssurl, $feed->error(), 'failure'));
					}
				}
			}
		}

		public function ranker_new_interval($schedules)
		{
			global $wpdb;
			$tablesettings 		= $wpdb->prefix.'seozen_settings';
			$getshcedule		= $wpdb->get_row($wpdb->prepare("SELECT activateschedule, jobtype, jobtypeschedule FROM $tablesettings WHERE id=%d", 1));

			if(!empty($getshcedule))
			{
				$isactive			= $getshcedule->activateschedule;
				$jobtypeschedule 	= $getshcedule->jobtypeschedule;
			}
			else
			{
				$isactive 			= 'off';
			}

			if($isactive == 'on')
			{
				$schedules['rk-hourly'] 	= array('interval' => $jobtypeschedule*(60*60), 'display' => 'Once '.$jobtypeschedule.' hour');
	    		$schedules['rk-daily']		= array('interval' => $jobtypeschedule*(24*3600), 'display' => 'Once '.$jobtypeschedule.' day');
	    		$schedules['rk-second']		= array('interval' => 60, 'display' => 'Once every minute');
	    		return $schedules;
    		}
    		else
    		{
    			$schedules['rk-hourly'] 	= array('interval' => 1*(60*60), 'display' => 'Once 1 hour');
	    		$schedules['rk-daily']		= array('interval' => 1*(24*3600), 'display' => 'Once 1 day');
	    		$schedules['rk-second']		= array('interval' => 60, 'display' => 'Once every minute');
	    		return $schedules;
    		}
		}

		public function ranker_remove_cron()
		{
			wp_clear_scheduled_hook('ranker_cron');
		}

		public function my_nav_exclude_pages( $args = array() )
		{
			$args['sort_column'] = "ID";
			return $args;
		}

		public function display_posts_seozen_spinner( $column, $post_id )
		{
			if($column == "seozen")
			{

				$spun = false;
				$postmeta = get_post_meta($post_id, "seozen_spinner", "spun", true);
				if((!empty($postmeta)) && ($postmeta == "spun"))
				{
					$spun = true;
				}

				if($spun)
				{
					?>
					<button class="seozenbutton_green">Spun By SEO Zen</button>
					<?php
				}
				else
				{
					?>
					<div>
					<button class="seozenbutton_red">Not Spun</button><br/>
					<button class="seozenbutton_blue" id="seozen_<?php echo $post_id; ?>">Spin This Post</button>
					</div>
					<?php
				}
			}
		}

		public function display_pages_seozen_spinner( $column, $post_id )
		{
			if($column == "seozen")
			{

				$spun = false;
				$postmeta = get_post_meta($post_id, "seozen_spinner", "spun", true);
				if((!empty($postmeta)) && ($postmeta == "spun"))
				{
					$spun = true;
				}

				if($spun)
				{
					?>
					<button class="seozenbutton_green">Spun By SEO Zen</button>
					<?php
				}
				else
				{
					?>
					<div>
					<button class="seozenbutton_red">Not Spun</button><br/>
					<button class="seozenbutton_blue" id="seozen_<?php echo $post_id; ?>">Spin This Page</button>
					</div>
					<?php
				}
			}
		}
		
		public function add_seozen_spun_column($columns)
		{
			return array_merge( $columns, array( 'seozen' => __( 'SEO Zen Spinner') ) );
		}
		

		public function exclude_pages($pages)
		{

			if(!is_admin())
			{
				$length = count($pages);
				for ($i=0; $i<$length; $i++)
				{
					$page = $pages[$i];

					$checked = get_post_meta($page->ID,"includeinmenu",true);
					if($checked == "" || $checked == "off")
					{
						unset($pages[$i]);
					}

				}

				if (!is_array($pages)) $pages = (array) $pages;
				$pages = array_values($pages);
			}

			return $pages;

		}

		public function ranker_admin_menu()
		{
			add_menu_page('SEO Zen', 'SEO Zen', 'manage_options', 'seozen', array($this, 'rankermenupage'), plugins_url('images/ico.png',__FILE__));
		}

		public function rankermenupage()
		{
			?>
				<div class="wrap">
					<?php
						screen_icon('options-general');
						$tab = isset( $_GET['tab'] ) ? $_GET['tab'] : "ranker_tab1";
					?>
					<h2 class="nav-tab-wrapper">
						<a class="nav-tab <?php if($tab == "ranker_tab1") echo "nav-tab-active"; ?>" href="?page=seozen&tab=ranker_tab1">SEO Zen</a>
					</h2>
					<?php require_once("code/mainarea.php"); ?>
					<?php
					global $wpdb;
					$table 	= $wpdb->prefix.'seozen_settings';
					if($wpdb->get_var("SHOW TABLES LIKE '$table'") != $table)
					{
						$this->manual_ranker_activate();
					}
					?>				
				</div>
			<?php
		}

		public function ranker_admin_head()
		{
			?>
			<script type="text/javascript">
				jQuery(document).ready(function(){jQuery("#rk_addrssurl_button").colorbox({inline:true,width:"30%",onComplete:function(){jQuery("#rk_hiddenrindex").val("");jQuery("#rk_hiddenrssid").val("");jQuery("#rk_rssurl").val("");jQuery("#rk_rssquantity").val("");jQuery("#rk_rsscategory").prop("selectedIndex",0);jQuery("#rk_rsssilo").prop("selectedIndex",0)}});var rsstable=jQuery("#rk_rssurl_datatable");rsstable.dataTable({bJQueryUI:true,sPaginationType:"full_numbers"});jQuery("#rk_rssurl_log").dataTable({aaSorting:[[3,"desc"]],bJQueryUI:true,sPaginationType:"full_numbers"});rsstable.on("click","a.rk_editrssurl",function(e){var rindex=rsstable.fnGetPosition(jQuery(this).closest("tr")[0]);var rssid=jQuery(this).attr("data");var $form=jQuery("#rk_addrssurl");jQuery.colorbox({inline:true,href:$form,width:"30%",onComplete:function(){data={action:"ranker_ajaxaction",node:"getrssurl",rssid:rssid};jQuery.post(ajax_object.ajax_url,data,function(response){var object=JSON.parse(response);jQuery("#rk_hiddenrssid").val(object.rssid);jQuery("#rk_hiddenrindex").val(rindex);jQuery("#rk_rssurl").val(object.rssurl);jQuery("#rk_rssquantity").val(object.quantity);jQuery("#rk_rsscategory").val(object.category);jQuery("#rk_rsssilo").val(object.silopage)})},onClosed:function(){jQuery(".rk_editrssurl").colorbox.close()}})});jQuery("#rk_mysilos_datatable").dataTable({bJQueryUI:true,sPaginationType:"full_numbers"});jQuery("#rk_scraped_datatable").dataTable({bJQueryUI:true,sPaginationType:"full_numbers"});jQuery("#rk_socialanalyze_datatables").dataTable({bJQueryUI:true,sPaginationType:"full_numbers"});jQuery("#rk_buttonsaverssurl").click(function(){var rindex=jQuery("#rk_hiddenrindex").val();var rssid=jQuery("#rk_hiddenrssid").val();var rssurl=jQuery("#rk_rssurl").val();var rssquantity=jQuery("#rk_rssquantity").val();var rsscategory=jQuery("#rk_rsscategory").val();var rsssilo=jQuery("#rk_rsssilo").val();if(""!=rssurl){jQuery("#rk_buttonsaverssurl").prop("disabled",true);data={action:"ranker_ajaxaction",node:"saverssurl",rssid:rssid,rssurl:rssurl,rssquantity:rssquantity,rsscategory:rsscategory,rsssilo:rsssilo};jQuery.post(ajax_object.ajax_url,data,function(response,status,jqXHR){jQuery("#rk_rssurl").val("");jQuery("#rk_rssquantity").val("");jQuery("#rk_rsscategory").val("");jQuery("#rk_rsssilo").val("");jQuery("#rk_addrssurl_button").colorbox.close();if(rssid==""){jQuery("#rk_rssurl_datatable").dataTable().fnAddData(eval(response))}else{var nrindex=parseInt(rindex,10);var object=JSON.parse(response);var oTable=jQuery("#rk_rssurl_datatable").dataTable();oTable.fnUpdate(object.rssurl,nrindex,0);oTable.fnUpdate(object.silopage,nrindex,1);oTable.fnUpdate(object.category,nrindex,2);oTable.fnUpdate(object.quantity,nrindex,3);oTable.fnUpdate(object.date,nrindex,4);oTable.fnUpdate(object.siloaction.replace(/\\/g,""),nrindex,5);return false}jQuery("#rk_buttonsaverssurl").prop("disabled",false)})}else{alert("Empty RSS Url!");return false}});jQuery("#rk_analyze_pages").click(function(){var url=jQuery("#rk_socializer_pages").val();data={action:"ranker_ajaxaction",node:"analyze",url:url};jQuery.post(ajax_object.ajax_url,data,function(response){jQuery("#rk_socialanalyze_datatables").dataTable().fnAddData(eval(response))})});jQuery("#rk_analyze_posts").click(function(){var url=jQuery("#rk_socializer_posts").val();data={action:"ranker_ajaxaction",node:"analyze",url:url};jQuery.post(ajax_object.ajax_url,data,function(response){jQuery("#rk_socialanalyze_datatables").dataTable().fnAddData(eval(response))})});jQuery("body").on("click",".rk_deleterssurl",function(event){var conf=confirm("Are you sure you want to delete the RSS Url?");if(conf==true){var id=jQuery(this).attr("data");var rindex=jQuery(this).closest("td").parent()[0].sectionRowIndex;if(jQuery("#rk_rssurl_datatable tbody tr").hasClass("row_selected")){jQuery("#rk_rssurl_datatable tbody tr").removeClass("row_selected")}else{jQuery("#rk_rssurl_datatable").dataTable().$("tr.row_selected").removeClass("row_selected");jQuery("#rk_rssurl_datatable > tbody > tr").eq(rindex).addClass("row_selected")}data={action:"ranker_ajaxaction",node:"deleterssurl",id:id};jQuery.ajax({type:"POST",url:ajax_object.ajax_url,data:data,success:function(response){var anSelected=fnGetSelected(jQuery("#rk_rssurl_datatable").dataTable());if(anSelected.length!==0){jQuery("#rk_rssurl_datatable").dataTable().fnDeleteRow(anSelected[0])}}})}else{return false}});jQuery("body").on("click",".rk_delete_silopage",function(event){var conf=confirm("Are you sure you want to delete the Silo?");if(conf==true){var id=jQuery(this).attr("data");var rindex=jQuery(this).closest("td").parent()[0].sectionRowIndex;if(jQuery("#rk_mysilos_datatable tbody tr").hasClass("row_selected")){jQuery("#rk_mysilos_datatable tbody tr").removeClass("row_selected")}else{jQuery("#rk_mysilos_datatable").dataTable().$("tr.row_selected").removeClass("row_selected");jQuery("#rk_mysilos_datatable > tbody > tr").eq(rindex).addClass("row_selected")}data={action:"ranker_ajaxaction",node:"deletesilo",id:id};jQuery.ajax({type:"POST",url:ajax_object.ajax_url,data:data,success:function(response){var anSelected=fnGetSelected(jQuery("#rk_mysilos_datatable").dataTable());if(anSelected.length!==0){jQuery("#rk_mysilos_datatable").dataTable().fnDeleteRow(anSelected[0])}jQuery("#includeinmenu_"+id).parents("tr").first().remove()}})}else{return false}});function fnGetSelected(oTableLocal){return oTableLocal.$("tr.row_selected")}});
			</script>
			
			<style type="text/css">
				#rk_rssurl_datatable, #rk_scraped_datatable, #rk_socialanalyze_datatables {border: solid 1px #222222;}
			</style>
			<?php
		}

		public function ranker_admin_enqueue_scripts()
		{
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_style('jquery-ui',plugins_url('css/jquery-ui.css', __FILE__), false, 'screen');
			wp_enqueue_style('style.css', plugins_url('css/style.css', __FILE__), false, 'screen');
			wp_enqueue_style('colorbox.css', plugins_url('css/colorbox-new.css', __FILE__), false, 'screen');
			wp_enqueue_style('jquery.dataTables.css', plugins_url('css/jquery.dataTables.css', __FILE__), false, 'screen');
			wp_enqueue_style('jquery.dataTables_themeroller.css', plugins_url('css/jquery.dataTables_themeroller.css', __FILE__), false, 'screen');

			wp_enqueue_script('jquery');
			wp_enqueue_script('jquery.colorbox.js', plugins_url('js/jquery.colorbox.js', __FILE__), array('jquery'));
			wp_enqueue_script('jquery.dataTables.js', plugins_url('js/jquery.dataTables.js', __FILE__), array('jquery'), '1.9.4');
			wp_enqueue_script('ranker_ajax', plugins_url('js/ranker_ajax.js', __FILE__), array('jquery'));
			wp_localize_script('ranker_ajax', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' )));

			wp_enqueue_script('seozen_spinner', plugins_url('js/seozen_spinner.js', __FILE__), array('jquery'));			
		}

		public function seozen_getezinearticlelinks()
		{
			global $wpdb;
			$tabepostmeta		= $wpdb->prefix.'postmeta';
			$getezinearticles 	= $wpdb->get_results($wpdb->prepare("SELECT meta_value FROM $tabepostmeta WHERE meta_key=%s", 'seozen_ezinelink'), ARRAY_A);
			foreach($getezinearticles as $ezine)
			{
				$articles[] = $ezine['meta_value'];
			}
			if(!empty($articles))
			{
				return $articles;	
			}
			else
			{
				return array();
			}
		}

		private function ranker_shuffle_assoc($list)
		{ 
			if (!is_array($list)) return $list; 

			$keys 	= array_keys($list); 
			shuffle($keys); 
			$random = array(); 
			foreach ($keys as $key) { 
				$proxies 		= $list[$key];
				$fetchproxies	= explode(",", $proxies);
				$count			= count($fetchproxies);
				$host 			= trim($fetchproxies[0]);
				
				if(isset($fetchproxies[1]) && is_numeric($fetchproxies[1]))
				{
					$port 	= trim($fetchproxies[1]);
				}
				else
				{
					$port 	= "80";
				}
				
				if(isset($fetchproxies[2]))
				{
					$username 	= trim($fetchproxies[2]);
				}
				else
				{
					$username 	= "";
				}
				
				if(isset($fetchproxies[3]))
				{
					$password 	= trim($fetchproxies[3]);
				}
				else
				{
					$password 	= "";
				}
				
				$return 	= array("host" => $host, "port" => $port, "username" => $username, "password"=> $password);
			}
			return $return;
		}

		public function ranker_ajaxaction()
		{
			global $wpdb;
			$tablesettings 		= $wpdb->prefix.'seozen_settings';
			$getdatasettings	= $wpdb->get_row($wpdb->prepare("SELECT * FROM $tablesettings WHERE id=%d", 1));

			$cmd = "";
			if(!empty($_POST['cmd'])) $cmd = $_POST['cmd'];

			if($cmd == "update_1a" && empty($_POST['fields']['hiddensilopageid']))
			{
				$siloname 			= $_POST['fields']['siloname'];
				$silopagekeywords 	= $_POST['fields']['silopagekeywords'];
				$articles 			= $_POST['fields']['articles'];
				$options 			= $_POST['fields']['options'];
				$affiliatelink 		= $_POST['fields']['affiliatelink'];

				$expkeyword 		= explode("\n", $silopagekeywords);
				$exparticle			= explode("\n", $articles);
				$silopagekeywords 	= array_merge(array($siloname), preg_split('/\r\n|[\r\n]/', $silopagekeywords));
				$articles 			= array_merge(array($siloname), preg_split('/\r\n|[\r\n]/', $articles));
				$parentid 			= -1;

				foreach($silopagekeywords as $key => $value)
				{
					if(!empty($value))
					{
						$silopagekeywords[$key] = trim($value);
						
						if(!empty($articles[$key]))
						{
							$articles[$key] = trim($value);
						}
						else
						{
							$articles[$key] = "";
						}

						$content = "";

						if($options == "options_1" || $options == "options_2")
						{
							
							try
							{

								$ezinequery 	= strtolower($articles[$key]);
								$ezinequery 	= str_replace(" ","-",$ezinequery);
								$ezinequery		.= "/";
								$ezineresponse 	= $this->ranker_curl("http://ezinemark.com/a/$ezinequery");

								$dom = new DOMDocument;
								@$dom->loadHTML($ezineresponse);

								$maindiv = $dom->getElementById("ct");

								$stories = array();
								
								if($maindiv)
								{
									
									$divtags = $maindiv->getElementsByTagName("div");
									$stories = array();
									foreach($divtags as $divtag)
									{
										if($divtag->getAttribute("class") == "l_search")
										{
											
											$h3tags = $divtag->getElementsByTagName("h3");
											if($h3tags)
											{
												foreach($h3tags as $h3tag)
												{
													$atags = $h3tag->getElementsByTagName("a");
													foreach($atags as $atag)
													{
														$link = $atag->getAttribute("href");
														$stories[] = array("article_link" => $link);
													}
												}
											}			
										}
									}

								}

								/*
								$ezineresponse 	= str_replace("widget({","{",$ezineresponse);
								$ezineresponse 	= str_replace("}]})","}]}",$ezineresponse);
								$ezineresponse 	= json_decode($ezineresponse);
								
								$stories		= $ezineresponse->story;
								*/

								
								
								foreach($stories as $article)
								{
									//var_dump($article->article_link);
									if(!in_array($article["article_link"], $this->seozen_getezinearticlelinks()))
									{
										$articlelink = str_replace(" ", "-", $article["article_link"]);
										break;
									}
								}

								//var_dump($articlelink);

								$article = $this->ranker_curl($articlelink);
								if(empty($article))
								{
									$article = @file_get_contents($articlelink);
								}
								
								$dom = new DOMDocument;
								@$dom->loadHTML($article);
								
								$divtags = $dom->getElementsByTagName("div");

								if($divtags)
								{

									foreach($divtags as $divtag)
									{
										if($divtag->getAttribute("class") == "adver")
										{
											$divtag->parentNode->removeChild($divtag);
										}
									}

									$articledom = $dom->getElementById('art_content');

									if($articledom)
									{

										$newdom = new DOMDocument;
										$newdom->appendChild($newdom->importNode($articledom,true));

										$articletext = $newdom->saveHTML();

										$content .= $articletext;
									}
									else
									{
										echo "An error occured while generating the pages. Please try again in a few minutes. (1)";
										exit();
									}
								}
								else
								{
									echo "An error occured while generating the pages. Please try again in a few minutes. (2)";
									exit();
								}

								/*$keywords = urlencode("site:ezinemark.com " . $articles[$key]);
								$searchresult = $this->ranker_curl("https://duckduckgo.com/html/?q=" . $keywords);

								$dom = new DOMDocument;
								@$dom->loadHTML($searchresult);

								$maindiv = $dom->getElementById("links");

								if($maindiv)
								{

									$divtags = $maindiv->getElementsByTagName("div");
									$stories = array();
									foreach($divtags as $divtag)
									{
										if($divtag->getAttribute("class") == "results_links results_links_deep web-result")
										{
											$atags = $divtag->getElementsByTagName("a");
											foreach($atags as $atag)
											{
												if($atag->getAttribute("class") == "large")
												{
													$link = $atag->getAttribute("href");
													$stories[] = array("article_link" => $link);
												}
											}
										}
									}

									foreach($stories as $article)
									{
										if(!in_array($article["article_link"], $this->seozen_getezinearticlelinks()))
										{
											$articlelink = $article["article_link"];
											break;
										}
									}

									sleep(5);									
									$article = $this->ranker_curl($articlelink);

									var_dump($articlelink);
									
									
									$dom = new DOMDocument;
									@$dom->loadHTML($article);
									
									$articledom = $dom->getElementById('article-content');

									if($articledom)
									{

										$newdom = new DOMDocument;
										$newdom->appendChild($newdom->importNode($articledom,true));

										$articletext = $newdom->saveHTML();

										$content .= $articletext;
									}
									else
									{
										echo "An error occured while generating the pages. Please try again in a few minutes.";
										exit();
									}

									$dom = new DOMDocument;
									@$dom->loadHTML($article);
									
									$divtags = $dom->getElementsByTagName("div");

									if($divtags)
									{

										foreach($divtags as $divtag)
										{
											if($divtag->getAttribute("class") == "adver")
											{
												$divtag->parentNode->removeChild($divtag);
											}
										}

										$articledom = $dom->getElementById('art_content');

										if($articledom)
										{

											$newdom = new DOMDocument;
											$newdom->appendChild($newdom->importNode($articledom,true));

											$articletext = $newdom->saveHTML();

											$content .= $articletext;
										}
										else
										{
											echo "An error occured while generating the pages. Please try again in a few minutes. (1)";
											exit();
										}

									}
									else
									{
										echo "An error occured while generating the pages. Please try again in a few minutes. (2)";
										exit();
									}
								}
								else
								{
									echo "An error occured while generating the pages. Please try again in a few minutes. (3)";
									exit();
								}
								*/

							}
							catch(Exception $e)
							{
								echo "An error occured while generating the pages. Please try again in a few minutes. (3)";
								exit();
							}

							
						}

						$newpage = array(
							'post_title'    => $value,
							'post_content'  => $content,
							'post_status'   => 'publish',
							'post_type'		=> 'page'
						  
						);

						if($parentid != -1)
						{
							$newpage["post_parent"] = $parentid;
						}

						$newpageid = wp_insert_post($newpage);

						update_post_meta($newpageid, 'seozen_ezinelink', $articlelink);

						if($options == "options_1" || $options == "options_3")
						{
							$youtubequery 		= urlencode(strtolower($value));
							$youtuberesponse 	= $this->ranker_curl("http://gdata.youtube.com/feeds/api/videos?q=$youtubequery");
							$youtubefeed 		= simplexml_load_string($youtuberesponse);
							$youtubeitemparts 	= explode("/",$youtubefeed->entry[0]->id);
							$youtubevideoid 	= $youtubeitemparts[count($youtubeitemparts) - 1];

							$video = "<div style='text-align: center;'><iframe width='420' height='315' src='//www.youtube.com/embed/$youtubevideoid' frameborder='0' allowfullscreen style='margin-bottom: 0px;'></iframe></div>";

							update_post_meta($newpageid, 'seozen_youtubevideo', $video);

						}

						/*$newaffiliatelink = "<div style='text-align: center; font-weight: bold;'><a href='$affiliatelink' target='_blank'>Click Here For More Info</a></div>";
						update_post_meta($newpageid, 'seozen_affiliatelink', $newaffiliatelink);*/

						if($parentid == -1)
						{
							$parentid = $newpageid;
						}
					}

					$return[$newpageid] = $value;
					$childpageid[]		= $newpageid;
				}

				$first_value 	= reset($return);
				$first_key 		= key($return);
				$deleteimage	= plugins_url('/images/delete.png', __FILE__);
				$editimage 		= plugins_url('/images/edit.png', __FILE__);

				$output  = '[';
				$output .= '"'.get_the_title($first_key).'"';
				$output .= ',';
				$html    = '<a href=\"#ranker_feature_1a\" class=\"rk_edit_silopage\" data=\"'.$first_key.'\"><img src=\"'.$editimage.'\" width=\"20px\"></img></a> <a href=\"#deletesilo\" class=\"rk_delete_silopage\" data=\"'.$first_key.'\"><img src=\"'.$deleteimage.'\" width=\"20px\"></img></a>';
				$output .= '"'.$html.'"';
				$output .= ']';

				$newreturn 		= array('list' => array($first_key => $first_value), 'rowdata' => $output);
				
				array_shift($childpageid);

				update_post_meta($first_key, 'seozen_siloname', $siloname);
				update_post_meta($first_key, 'seozen_silochilds', json_encode($childpageid));
				update_post_meta($first_key, 'seozen_silokeywords', json_encode($expkeyword));
				update_post_meta($first_key, 'seozen_siloarticles', json_encode($exparticle));
				update_post_meta($first_key, 'seozen_silooptions', $options);
				update_post_meta($first_key, 'seozen_siloaffiliatelink', $affiliatelink);

				echo json_encode($newreturn);
				exit();
			}

			if($cmd == "update_1a" && !empty($_POST['fields']['hiddensilopageid']))
			{
				$hiddensiloid 		= $_POST['fields']['hiddensilopageid'];
				$siloname 			= $_POST['fields']['siloname'];
				$silopagekeywords 	= $_POST['fields']['silopagekeywords'];
				$articles 			= $_POST['fields']['articles'];
				$options 			= $_POST['fields']['options'];
				$affiliatelink 		= $_POST['fields']['affiliatelink'];

				$silopagekeywords 	= explode("\n", $silopagekeywords);
				$articles			= explode("\n", $articles);

				$getpostmeta 		= get_post_meta($hiddensiloid);
				$silokeyword  		= $getpostmeta['seozen_silokeywords'];
				$silochild 			= $getpostmeta['seozen_silochilds'];
				$silokeywords 		= json_decode($silokeyword[0]);
				$silochilds 		= json_decode($silochild[0]);

				$newchildpageid 	= $silochilds;
				$newpageid 			= "";

				foreach($silokeywords as $foundexistingchildpage)
				{
					if(!in_array($foundexistingchildpage, $silopagekeywords))
					{
						$getidbytitle 	= get_page_by_title($foundexistingchildpage);
						$foundid 		= $getidbytitle->ID;
						if($foundid != NULL)
						{
							wp_delete_post($foundid);
							delete_post_meta($foundid, 'includeinmenu');

							$arrayfoundid	= array($foundid);
							$newchildpageid	= array_diff($silochilds, $arrayfoundid);
						}
					}
				}

				foreach($silopagekeywords as $key => $value)
				{
					if(!empty($value))
					{
						if(!in_array($value, $silokeywords))
						{
							$silopagekeywords[$key] = trim($value);
							if(!empty($articles[$key]))
							{
								$articles["key"] = trim($value);
							}
							else
							{
								$articles[$key] = "";
							}

							$content = "";

							if($options == "options_1" || $options == "options_2")
							{
								$ezinequery 	= strtolower($articles[$key]);
								$ezinequery 	= str_replace(" ","_",$ezinequery);
								$ezineresponse 	= $this->ranker_curl("http://ezinemark.com/widget/widget.php?keyword=$ezinequery");

								$ezineresponse 	= str_replace("widget({","{",$ezineresponse);
								$ezineresponse 	= str_replace("}]})","}]}",$ezineresponse);
								$ezineresponse 	= json_decode($ezineresponse);

								$stories		= $ezineresponse->story;
								foreach($stories as $article)
								{
									if(!in_array($article->article_link, $this->seozen_getezinearticlelinks()))
									{
										$article_link[] = $article->article_link;
									}
								}
								$articlelink 	= str_replace(" ", "-", $article_link[0]);

								$article 		= $this->ranker_curl($articlelink);
								
								if(empty($article))
								{
									$article = @file_get_contents($articlelink);
								}
								
								$dom = new DOMDocument;
								@$dom->loadHTML($article);
								
								$divtags = $dom->getElementsByTagName("div");

								foreach($divtags as $divtag)
								{
									if($divtag->getAttribute("class") == "adver")
									{
										$divtag->parentNode->removeChild($divtag);
									}
								}

								$articledom = $dom->getElementById('art_content');

								$newdom = new DOMDocument;
								$newdom->appendChild($newdom->importNode($articledom,true));

								$articletext = $newdom->saveHTML();

								$content .= $articletext;
							}

							$newpage = array(
								'post_title'    => $value,
								'post_content'  => $content,
								'post_status'   => 'publish',
								'post_type'		=> 'page',
								'post_parent'	=> $hiddensiloid
							  
							);

							$newpageid = wp_insert_post($newpage);
		
							update_post_meta($newpageid, 'seozen_ezinelink', $articlelink);
							update_post_meta($newpageid, 'includeinmenu', 'on');
							
							if($options == "options_1" || $options == "options_3")
							{
								$youtubequery 		= urlencode(strtolower($value));
								$youtuberesponse 	= $this->ranker_curl("http://gdata.youtube.com/feeds/api/videos?q=$youtubequery");
								$youtubefeed 		= simplexml_load_string($youtuberesponse);
								$youtubeitemparts 	= explode("/",$youtubefeed->entry[0]->id);
								$youtubevideoid 	= $youtubeitemparts[count($youtubeitemparts) - 1];

								$video = "<div style='text-align: center;'><iframe width='420' height='315' src='//www.youtube.com/embed/$youtubevideoid' frameborder='0' allowfullscreen style='margin-bottom: 0px;'></iframe></div>";

								update_post_meta($newpageid, 'seozen_youtubevideo', $video);
							
							}

							/*$newaffiliatelink = "<div style='text-align: center; font-weight: bold;'><a href='$affiliatelink' target='_blank'>Click Here For More Info</a></div>";
							update_post_meta($newpageid, 'seozen_affiliatelink', $newaffiliatelink);*/

						}
					}
				}

				if(is_array($newchildpageid))
				{
					$nchildpageid 	= array_merge($newchildpageid, array($newpageid));
					update_post_meta($hiddensiloid, 'seozen_silochilds', json_encode($nchildpageid));
				}
				else
				{
					$nchildpageid 	= array($newpageid);
					update_post_meta($hiddensiloid, 'seozen_silochilds', json_encode($nchildpageid));
				}

				update_post_meta($hiddensiloid, 'seozen_siloname', $siloname);
				update_post_meta($hiddensiloid, 'seozen_silokeywords', json_encode($silopagekeywords));
				update_post_meta($hiddensiloid, 'seozen_siloarticles', json_encode($articles));
				update_post_meta($hiddensiloid, 'seozen_silooptions', $options);
				update_post_meta($hiddensiloid, 'seozen_siloaffiliatelink', $affiliatelink);
				
				echo 'The pages were successfully updated.';
				exit();
			}

			if($_POST['node'] == 'checkspinsettings')
			{
				if($getdatasettings->spinactive == 'off' && $getdatasettings->spinnerchiefactive == 'off')
					exit('The page/post can not be spun at this moment. Please activate one of the Spinner and then try again.');
					
				if($getdatasettings->spinactive == 'on' && empty($getdatasettings->spinemail))
					exit('The page/post can not be spun at this moment. Configure your Spinrewriter and then try again.');
				
				if($getdatasettings->spinactive == 'on' && empty($getdatasettings->spinapikey))
					exit('The page/post can not be spun at this moment. Configure your Spinrewriter and then try again.');

				if($getdatasettings->spinnerchiefactive == 'on' && empty($getdatasettings->spinnerchiefusername))
					exit('The page/post can not be spun at this moment. Configure your Spinnerchief and then try again.');

				if($getdatasettings->spinnerchiefactive == 'on' && empty($getdatasettings->spinnerchiefpassword))
					exit('The page/post can not be spun at this moment. Configure your Spinnerchief and then try again.');

				if($getdatasettings->spinnerchiefactive == 'on' && empty($getdatasettings->spinnerchieffrequency))
					exit('The page/post can not be spun at this moment. Configure your Spinnerchief and then try again.');
			}

			if($_POST['node'] == 'editsilo')
			{
				$siloid = $_POST['siloid'];

				if(!empty($_POST['siloid']))
				{
					$post 	= get_post_meta($siloid);
					echo json_encode($post);
					exit();
				}
			}

			if($cmd == "update_1a_menu")
			{
				$includeinmenu 		= $_POST['fields']['includeinmenu'];
				$includeinmenulist 	= explode(";",$includeinmenu);

				$output = '[';
				foreach($includeinmenulist as $includepage)
				{
					$includepage = trim($includepage);
					if($includepage != "")
					{
						update_post_meta($includepage, "includeinmenu", "on");

						$output .= '[';
						$output .= '"'.get_the_title($includepage).'"';
						$output .= ',';
						$html    = '<a href=\"#ranker_feature_1a\" class=\"rk_edit_silopage\" data=\"'.$includepage.'\">Edit</a> <a href=\"#deletesilo\" class=\"rk_delete_silopage\" data=\"'.$includepage.'\">Delete</a>';
						$output .= '"'.$html.'"';
						$output .= ']';
						$output .= ',';

						$my_wp_query 	= new WP_Query();
						$all_wp_pages 	= $my_wp_query->query(array('post_type' => 'page'));
						$getallpages 	= get_page_children( $includepage, $all_wp_pages );
						foreach($getallpages as $allpages)
						{
							update_post_meta($allpages->ID,"includeinmenu","on");
						}
					}
				}
				$output .= ']';
				echo $output;

				$excludefrommenu 		= $_POST['fields']['excludefrommenu'];
				$excludefrommenulist 	= explode(";",$excludefrommenu);
				
				foreach($excludefrommenulist as $excludepage)
				{
					$excludepage = trim($excludepage);
					if($excludepage != "")
					{
						update_post_meta($excludepage,"includeinmenu","off");

						$my_wp_query 	= new WP_Query();
						$all_wp_pages 	= $my_wp_query->query(array('post_type' => 'page'));
						$getallpages 	= get_page_children( $excludepage, $all_wp_pages );
						foreach($getallpages as $allpages)
						{
							update_post_meta($allpages->ID,"includeinmenu","off");
						}
					}
				}

				exit();
			}

			if($_POST['node'] == 'getrssurl')
			{
				global $wpdb;
				$rssid 		= $_POST['rssid'];
				$tablerss	= $wpdb->prefix.'seozen_rss';
				$getrss 	= $wpdb->get_row($wpdb->prepare("SELECT * FROM $tablerss WHERE id=%d", $rssid));
				$array 		= array(
					'rssid'		=> $getrss->id,
					'rssurl'	=> $getrss->rssurl,
					'category'	=> $getrss->category,
					'quantity'	=> $getrss->quantity,
					'silopage'	=> $getrss->silopage
				);
				echo json_encode($array);
				exit();
			}

			if($_POST['node'] == 'saverssurl')
			{
				$rssid 			= $_POST['rssid'];
				$rssurl 		= $_POST['rssurl'];
				$rssquantity 	= $_POST["rssquantity"];
				$rsscategory 	= $_POST["rsscategory"];
				$rsssilo 		= $_POST['rsssilo'];

				global $wpdb;
				$tablerss	= $wpdb->prefix.'seozen_rss';
				$wpdb->query($wpdb->prepare("INSERT INTO $tablerss (id, rssurl, quantity, category, created, silopage) VALUES (%d, %s, %d, %d, now(), %s) ON DUPLICATE KEY UPDATE rssurl=%s, quantity=%d, category=%d, created=now(), silopage=%s", $rssid, $rssurl, $rssquantity, $rsscategory, $rsssilo, $rssurl, $rssquantity, $rsscategory, $rsssilo));
				$inid		= $wpdb->insert_id;
				if(!empty($inid))
				{
					$return	= $wpdb->get_row($wpdb->prepare("SELECT * FROM $tablerss WHERE id=%d", $inid));
					$deleteimage	= plugins_url('/images/delete.png', __FILE__);
					$editimage 		= plugins_url('/images/edit.png', __FILE__);

					$output = '[';
					$output .= '"'.$return->rssurl.'"';
					$output .= ',';

					$output .= '"'.get_the_title($return->silopage).'"';
					$output .= ',';

					$output .= '"'.$return->category.'"';
					$output .= ',';

					$output .= $return->quantity;
					$output .= ',';

					$output .= '"'.$return->created.'"';
					$output .= ',';

					$html 	 = '<a href=\"#deleterssurl\" class=\"rk_deleterssurl\" data=\"'.$return->id.'\"><img src=\"'.$deleteimage.'\" width=\"20px\"></img></a> <a href=\"#rk_addrssurl\" class=\"rk_editrssurl\" data=\"'.$return->id.'\"><img src=\"'.$editimage.'\" width=\"20px\"></img></a>';
					$output .= '"' . $html . '"';
					$output .= ']';

					if(empty($rssid))
					{
						echo $output;
						if($getdatasettings->publishinstantly == "on")
						{
							$oldrssurl = str_ireplace("http://","",$rssurl);
							$oldrssurl = str_ireplace("https://","",$oldrssurl);
							
							$newrssurl = plugins_url("rss/makefulltextfeed.php?url=", __FILE__) . urlencode($oldrssurl) . "&max=10";

							$feed = new SimplePie();
							$feed->enable_cache(false);
							$feed->set_feed_url($newrssurl);
							$feed->set_timeout(60);

							$success = false;
							$success = $feed->init();							

							if($success)
							{
								$rsscounter = 0;
								$items = array_reverse($feed->get_items());
								
								foreach($items as $item)
								{
									$articletext = $item->get_content();

									$newpage = array(
										'post_title'    => $item->get_title(),
										'post_content'  => $articletext,
										'post_status'   => 'publish',
										'post_type'		=> 'post',
										'post_category' => array($rsscategory),
										'post_parent'	=> $rsssilo
									);

									$newpageid = wp_insert_post($newpage);

									$rsscounter++;
									if($rsscounter >= $rssquantity) break;
								}
							}
						}
						exit();
					}
					else
					{
						$array = array(
							'rssurl'		=> $return->rssurl,
							'silopage'		=> get_the_title($return->silopage),
							'category'		=> $return->category,
							'quantity'		=> $return->quantity,
							'date'			=> $return->created,
							'siloaction'	=> $html
						);
						echo json_encode($array);
						exit();
					}
				}
				else
				{
					echo 'Could not save rss url, please try again!';
					exit();
				}
			}
			elseif($_POST['node'] == 'findbacklinks')
			{
				$optionsfind 	= $_POST["optionsfind"];
				$keywordsearch 	= $_POST["keywordsearch"];

				$usegooglecse 		= $getdatasettings->usegooglecse;
				$googlecseapikey 	= $getdatasettings->googlecseapikey;
				$seid 				= $getdatasettings->seid;

				$usewebproxies 		= $getdatasettings->usewebproxies;
				$proxies 			= explode("\n", $getdatasettings->proxies);
				$randproxy			= $this->ranker_shuffle_assoc($proxies);

				if($usegooglecse == 'yes')
				{
					$query = array();
					$query["edu-backlinks"] 		= $keywordsearch . ' site:.edu inurl:blog "post a comment" -"you must be logged in"';
					$query["gov-backlinks"] 		= $keywordsearch . ' site:.gov inurl:blog "post a comment" -"you must be logged in"';
					$query["html-comments"] 		= $keywordsearch . ' "Allowed HTML tags:"';
					$query["angelas-backlinks"] 	= $keywordsearch . ' "angelae8654"';
					$query["comment-luv-premium"] 	= $keywordsearch . ' "This blog uses premium CommentLuv" -"The version of CommentLuv on this site is no longer supported."';
					$query["do-follow-comments"] 	= $keywordsearch . ' "Notify me of follow-up comments?" "Submit the word you see below:"';

					$query["expression-engine"] 	= $keywordsearch . ' "powered by expressionengine"';
					$query["hubpages"] 				= $keywordsearch . ' site:hubpages.com "hot hubs"';
					$query["keywordluv"] 			= $keywordsearch . ' "Enter YourName@YourKeywords"';
					$query["livefyre"] 				= $keywordsearch . ' "get livefyre" "comment help" -"Comments have been disabled for this post"';
					$query["intensedebate"] 		= $keywordsearch . ' "if you have a website, link to it here" "post a new comment"';
					$query["squidoo-addtolist"] 	= $keywordsearch . ' "add to this list" site:squidoo.com';

					$newkeyword = $query[$optionsfind];

					$googlerankchecker 		= new GoogleRankChecker();
					$googlecustomsearch 	= new GoogleCustomSearch();

					$googledata = $googlecustomsearch->customSearch($googlecseapikey, $seid, $newkeyword);
					
					$arraycheck = $googledata[0];

					if(is_array($googledata))
					{
						$rows = "[";
						if(in_array('Empty results', $arraycheck))
						{
							$rows .= "['0', 'Empty results'],";
						}
						else
						{
							foreach($googledata as $data)
							{
								$get 		= $googlerankchecker->get_web_page($data["link"]);
								$urlrank	= $get['url'];
								$pagerank 	= "0";
								if(preg_match('/[0-9]{1,2}\.gif/', $urlrank, $matches) == 1)
								{
									$pagerank = str_ireplace(".gif","",$matches[0]);
								}
								
								$rows .= "['".$pagerank."', '<a href=\"" . $data["link"] . "\" target=\"_blank\">" . $data["link"] . "</a>'],";
							}
						}
						$rows = rtrim($rows,",");
						$rows .= "]";
					}

					echo $rows;
					exit();
				}
				else
				{
					$query = array();
					$query["edu-backlinks"] 		= $keywordsearch . ' site:.edu inurl:blog "post a comment" -"you must be logged in"';
					$query["gov-backlinks"] 		= $keywordsearch . ' site:.gov inurl:blog "post a comment" -"you must be logged in"';
					$query["html-comments"] 		= $keywordsearch . ' "Allowed HTML tags:"';
					$query["angelas-backlinks"] 	= $keywordsearch . ' "angelae8654"';
					$query["comment-luv-premium"] 	= $keywordsearch . ' "This blog uses premium CommentLuv" -"The version of CommentLuv on this site is no longer supported."';
					$query["do-follow-comments"] 	= $keywordsearch . ' "Notify me of follow-up comments?" "Submit the word you see below:"';

					$query["expression-engine"] 	= $keywordsearch . ' "powered by expressionengine"';
					$query["hubpages"] 				= $keywordsearch . ' site:hubpages.com "hot hubs"';
					$query["keywordluv"] 			= $keywordsearch . ' "Enter YourName@YourKeywords"';
					$query["livefyre"] 				= $keywordsearch . ' "get livefyre" "comment help" -"Comments have been disabled for this post"';
					$query["intensedebate"] 		= $keywordsearch . ' "if you have a website, link to it here" "post a new comment"';
					$query["squidoo-addtolist"] 	= $keywordsearch . ' "add to this list" site:squidoo.com';

					$newquery = $query[$optionsfind];

					try
					{
						$newGoogleRankChecker = new GoogleRankChecker();

						if($usewebproxies == 'yes')
						{
							$useproxies = true;
						}
						else
						{
							$useproxies = false;
						}

						$googledata 		= $newGoogleRankChecker->find($newquery, $useproxies, $randproxy);
						$googledataunique 	= array_map("unserialize", array_unique(array_map("serialize", $googledata)));

						if(is_array($googledata))
						{
							$rows = "[";
							if(in_array('zero', $googledata))
							{
								$rows .= "['0', 'The results could not be retrieved due to Google blocking the server IP temporarily.'],";
							}
							elseif(in_array('zerox', $googledata))
							{
								$rows .= "['0', '".$googledata['url']."'],";
							}
							else
							{
								$i = 1;
								foreach($googledataunique as $data)
								{
									$get 		= $newGoogleRankChecker->get_web_page($data["url"]);
									$urlrank	= $get['url'];
									$pagerank 	= "0";
									if(preg_match('/[0-9]{1,2}\.gif/', $urlrank, $matches) == 1)
									{
										$pagerank = str_ireplace(".gif","",$matches[0]);
									}
									
									$linkshorten 	= (strlen($data["url"]) > 60) ? substr($data["url"],0,60).'...' : $data["url"];

									$rows .= "['".$pagerank."', '<a href=\"http://" . $data["url"] . "\" target=\"_blank\">" . $linkshorten . "</a>'],";

									if($i == 30)
									{
										break;
									}
									$i++;
								}
							}
							$rows = rtrim($rows,",");
							$rows .= "]";
						}

						echo $rows;

					}
					catch(Exception $e)
					{

					}
					exit();
				}
			}
			elseif($_POST['node'] == 'savesettings')
			{
				$activateschedule 		= $_POST['activateschedule'];
				$jobtype				= $_POST['jobtype'];
				$jobtypeschedule 		= $_POST['jobtypeschedule'];
				$publishinstantly 		= $_POST['publishinstantly'];
				$spinactive				= $_POST['spinactive'];
				$spinemail				= $_POST['spinemail'];
				$spinapikey				= $_POST['spinapikey'];
				$spinsetting1			= $_POST['spinsetting1'];
				$spinsetting2			= $_POST['spinsetting2'];
				$spinsetting3			= $_POST['spinsetting3'];
				$spinsetting4			= $_POST['spinsetting4'];
				$spinrefine				= '';//$_POST['spinrefine'];
				$spinprotectedkeywords	= $_POST['spinprotectedkeywords'];
				$linksposts				= $_POST['linksposts'];
				$linkspages				= $_POST['linkspages'];
				$linkscomments			= $_POST['linkscomments'];
				$linksignore			= $_POST['linksignore'];
				$linksmaximum			= $_POST['linksmaximum'];
				$linkscustomkeywords	= $_POST['linkscustomkeywords'];
				$linksredirectexternal	= $_POST['linksredirectexternal'];
				$socialactive			= $_POST['socialactive'];
				$socialfbappid			= $_POST['socialfbappid'];
				$socialfb 				= $_POST['socialfb'];
				$socialtwitter			= $_POST['socialtwitter'];
				$socialgoogle			= $_POST['socialgoogle'];
				$socialpinterest		= $_POST['socialpinterest'];

				$spinnerchiefactive 	= $_POST['spinnerchiefactive'];
				$spinnerchiefusername 	= $_POST['spinnerchiefusername'];
				$spinnerchiefpassword 	= $_POST['spinnerchiefpassword'];
				$spinnerchiefapikey 	= $_POST['spinnerchiefapikey'];
				$spinnerchiefoptions 	= $_POST['spinnerchiefoptions'];
				$spinnerchieffrequency 	= $_POST['spinnerchieffrequency'];
				
				$usegooglecse 			= '';//$_POST['usegooglecse'];
				$googlecseapikey 		= '';//$_POST['googlecseapikey'];
				$seid 					= '';//$_POST['seid'];

				$usewebproxies 			= $_POST['usewebproxies'];
				$proxies 				= $_POST['proxies'];

				global $wpdb;
				$tablesettings	= $wpdb->prefix.'seozen_settings';

				$wpdb->query($wpdb->prepare("INSERT INTO $tablesettings (id, activateschedule, jobtype, jobtypeschedule, publishinstantly, spinactive, spinemail, spinapikey, spinsetting1, spinsetting2, spinsetting3, spinsetting4, spinrefine, spinprotectedkeywords, linksposts, linkspages, linkscomments, linksignore, linksmaximum, linkscustomkeywords, linksredirectexternal, socialactive, socialfbappid, socialfb, socialtwitter, socialgoogle, socialpinterest, spinnerchiefactive, spinnerchiefusername, spinnerchiefpassword, spinnerchiefapikey, spinnerchiefoptions, spinnerchieffrequency, usegooglecse, googlecseapikey, seid, usewebproxies, proxies) VALUES (%d, %s, %s, %d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) ON DUPLICATE KEY UPDATE activateschedule=%s, jobtype=%s, jobtypeschedule=%d, publishinstantly=%s, spinactive=%s, spinemail=%s, spinapikey=%s, spinsetting1=%s, spinsetting2=%s, spinsetting3=%s, spinsetting4=%s, spinrefine=%s, spinprotectedkeywords=%s, linksposts=%s, linkspages=%s, linkscomments=%s, linksignore=%s, linksmaximum=%s, linkscustomkeywords=%s, linksredirectexternal=%s, socialactive=%s, socialfbappid=%s, socialfb=%s, socialtwitter=%s, socialgoogle=%s, socialpinterest=%s, spinnerchiefactive=%s, spinnerchiefusername=%s, spinnerchiefpassword=%s, spinnerchiefapikey=%s, spinnerchiefoptions=%s, spinnerchieffrequency=%s, usegooglecse=%s, googlecseapikey=%s, seid=%s, usewebproxies=%s, proxies=%s", 1, $activateschedule, $jobtype, $jobtypeschedule, $publishinstantly, $spinactive, $spinemail, $spinapikey, $spinsetting1, $spinsetting2, $spinsetting3, $spinsetting4, $spinrefine, $spinprotectedkeywords, $linksposts, $linkspages, $linkscomments, $linksignore, $linksmaximum, $linkscustomkeywords, $linksredirectexternal, $socialactive, $socialfbappid, $socialfb, $socialtwitter, $socialgoogle, $socialpinterest, $spinnerchiefactive, $spinnerchiefusername, $spinnerchiefpassword, $spinnerchiefapikey, $spinnerchiefoptions, $spinnerchieffrequency, $usegooglecse, $googlecseapikey, $seid, $usewebproxies, $proxies, $activateschedule, $jobtype, $jobtypeschedule, $publishinstantly, $spinactive, $spinemail, $spinapikey, $spinsetting1, $spinsetting2, $spinsetting3, $spinsetting4, $spinrefine, $spinprotectedkeywords, $linksposts, $linkspages, $linkscomments, $linksignore, $linksmaximum, $linkscustomkeywords, $linksredirectexternal, $socialactive, $socialfbappid, $socialfb, $socialtwitter, $socialgoogle, $socialpinterest, $spinnerchiefactive, $spinnerchiefusername, $spinnerchiefpassword, $spinnerchiefapikey, $spinnerchiefoptions, $spinnerchieffrequency, $usegooglecse, $googlecseapikey, $seid, $usewebproxies, $proxies));
				
				//echo $wpdb->show_errors();
				//echo $wpdb->print_error();

				$inid = $wpdb->insert_id;

				$this->ranker_remove_cron();

				echo "Saved";
				exit();
			}
			elseif($_POST['node'] == 'analyze')
			{
				$url = $_POST['url'];
				$scjson 			= $this->ranker_curl("http://api.sharedcount.com/?url=" . rawurlencode($url));
				$scdata				= json_decode($scjson);

				$stumbleupon		= (int)$scdata->StumbleUpon;
				$fbcommentcount		= (int)$scdata->Facebook->comment_count;
				$fblikecount		= (int)$scdata->Facebook->like_count;
				$fbsharecount		= (int)$scdata->Facebook->share_count;
				$delicious			= (int)$scdata->Delicious;
				$googleplusone		= (int)$scdata->GooglePlusOne;
				$twitter			= (int)$scdata->Twitter;
				$pinterest			= (int)$scdata->Pinterest;
				$linkedin			= (int)$scdata->LinkedIn;

				$output  = '[';
		
				$output .= '"'.$url.'"';
				$output .= ',';

				$output .= $fblikecount;
				$output .= ',';

				$output .= $fbsharecount;
				$output .= ',';

				$output .= $fbcommentcount;
				$output .= ',';

				$output .= $twitter;
				$output .= ',';

				$output .= $googleplusone;
				$output .= ',';

				$output .= $pinterest;
				$output .= ',';

				$output .= ']';

				echo $output;
				exit();
			}
			elseif($_POST['node'] == 'deleterssurl')
			{
				$id 	= $_POST['id'];
				global $wpdb;
				$tablerss	= $wpdb->prefix.'seozen_rss';

				$isdeleted 	= $wpdb->query($wpdb->prepare("DELETE FROM $tablerss WHERE id=%d", $id));
				if($isdeleted) echo 'deletesuccess';
			}
			elseif($_POST['node'] == "spinpostpage")
			{
				$postid 		= $_POST["postid"];
				$articletext 	= get_post_field('post_content', $postid);

				if($getdatasettings->spinnerchiefactive == 'on')
				{
					$spinnerchiefusername 	= $getdatasettings->spinnerchiefusername;
					$spinnerchiefpassword 	= $getdatasettings->spinnerchiefpassword;
					$spinnerchiefapikey 	= $getdatasettings->spinnerchiefapikey;
					$spinnerchieffrequency 	= $getdatasettings->spinnerchieffrequency;

					$article = $articletext;
					if($getdatasettings->spinnerchiefoptions == 'orderly')
					{
						$spinnerchiefoptions = 0;
					}
					else
					{
						$spinnerchiefoptions = 1;
					}

					$queryparams 	= array(
						'apikey' 		=> $spinnerchiefapikey,
						'username'		=> $spinnerchiefusername,
						'password' 		=> $spinnerchiefpassword,
						'spinfreq' 		=> $spinnerchieffrequency,
						'orderly' 		=> $spinnerchiefoptions,
						'Orderly' 		=> $spinnerchiefoptions,
						'spintype' 		=> 1
						);
					$url_request 	= 'http://api.spinnerchief.com:443/';
					$query 			= http_build_query($queryparams);
					$request 		= $url_request.$query;
					$articletext 	= $this->curl_request_spinnerchief($request, $article);

					/*
					$finderror 		= strpos('error', $articletext);
					if($finderror !== FALSE)
					{
						$articletext = $articletext;
					}
					else
					{
						$articletext = $article;
						echo json_encode(array('apistatus' => 'error', 'message' => 'Please check your Spinnerchief credential.'));
					}
					*/
				}

				if($getdatasettings->spinactive == 'on')
				{
					$email_address 	= $getdatasettings->spinemail;
					$api_key 		= $getdatasettings->spinapikey;

					$spinrewriter_api 	= new SeozenSpinRewriterAPI($email_address, $api_key);
					$protected_terms 	= $getdatasettings->spinprotectedkeywords;
					$spinrewriter_api->setProtectedTerms($protected_terms);
					$spinrewriter_api->setAutoProtectedTerms(false);
					$spinrewriter_api->setConfidenceLevel("medium");
					if($getdatasettings->spinsetting1 == "1") $spinrewriter_api->setConfidenceLevel("high");
					if($getdatasettings->spinsetting1 == "2") $spinrewriter_api->setConfidenceLevel("medium");
					if($getdatasettings->spinsetting1 == "3") $spinrewriter_api->setConfidenceLevel("low");
					
					$spinrewriter_api->setNestedSpintax(true);
					$spinrewriter_api->setAutoSentences(false);
					$spinrewriter_api->setAutoParagraphs(false);
					$spinrewriter_api->setAutoNewParagraphs(false);
					$spinrewriter_api->setAutoSentenceTrees(false);
					$spinrewriter_api->setUseOnlySynonyms(false);
					$api_response = $spinrewriter_api->getUniqueVariation($articletext);
					sleep(5);

					if($api_response['status'] == 'ERROR')
					{
						$articletext = $articletext;
						echo json_encode(array('apistatus' => 'error', 'message' => $api_response['response']));
					}
					else
					{
						
						$articletext = $api_response["response"];
					}
				}

				$my_post = array();
				$my_post['ID'] 				= $postid;
				$my_post['post_content'] 	= $articletext;

				wp_update_post($my_post);

				update_post_meta($postid, "seozen_spinner", "spun");

				//echo "The post '" . get_post_field('post_title', $postid) . "' was spun successfully!";

				exit();
			}
			elseif($_POST['node'] == 'deletesilo')
			{
				$siloid = $_POST['id'];
				echo $siloid;
				wp_delete_post($siloid);
				$my_wp_query 	= new WP_Query();
				$all_wp_pages 	= $my_wp_query->query(array('post_type' => 'page'));
				$getallpages 	= get_page_children( $siloid, $all_wp_pages );
				foreach($getallpages as $allpages)
				{
					wp_delete_post($allpages->ID);
				}
			}
		}

		public function ranker_filter_thecontent($content)
		{
			global $wpdb;
			global $post;
			$tablesettings 		= $wpdb->prefix.'seozen_settings';
			$getdatasettings	= $wpdb->get_row($wpdb->prepare("SELECT * FROM $tablesettings WHERE id=%d", 1));
			$socialfbappid 		= $getdatasettings->socialfbappid;

			$linksmaximum = $getdatasettings->linksmaximum;
			if($linksmaximum == "unlimited") $linksmaximum = -1;

			$content = str_replace("& rsquo; ","",$content);
			$content = str_replace("& lsquo; ","",$content);

			if((($post->post_type == "post") && ($getdatasettings->linksposts == "on")) || (($post->post_type == "page") && ($getdatasettings->linkspages == "on")))
			{
				$monetize 		= true;
				$linksignore 	= preg_split('/,/', $getdatasettings->linksignore);

				if(is_array($linksignore))
				{
					$trimmedlinksignore = array_map('trim', $linksignore);
					$trimmedlinksignore_lower = array_map('strtolower', $trimmedlinksignore);
					if(in_array($post->ID,$trimmedlinksignore_lower))
					{
						$monetize = false;
					}
					if(in_array($post->post_title,$trimmedlinksignore_lower))
					{
						$monetize = false;
					}
					if(in_array($post->post_name,$trimmedlinksignore_lower))
					{
						$monetize = false;
					}
				}

				if($monetize)
				{
					$newexternalurl = trim($getdatasettings->linksredirectexternal);
					$content 		= preg_replace('/<a(.*?)href="(.*?)"(.*?)>/i','<a href="' . $newexternalurl . '" target="_blank">',$content); //, $linksmaximum);

					/*
					$externallinks = preg_split('/\r\n|[\r\n]/', $getdatasettings->linksredirectexternal);
					$trimmedexternallinks = array_map('trim', $externallinks);

					$args=array(
						'orderby' => 'name',
						'order' => 'ASC',
						'hide_empty' => 0
					);
					
					$categories = get_categories($args);

					$postcategories = get_the_category($post->ID);
					if($postcategories)
					{
						$postcategory = $postcategories[0];

						$categorycounter = 0;
						foreach($categories as $category)
						{
							if($category->cat_ID == $postcategory->cat_ID)
							{
								if(!empty($trimmedexternallinks[$categorycounter]))
								{
									//var_dump($trimmedexternallinks[$categorycounter]);
									$newexternalurl = $trimmedexternallinks[$categorycounter];

									$content = preg_replace('/<a(.*?)href="(.*?)"(.*?)>/i','<a href="' . $newexternalurl . '" target="_blank">',$content); //, $linksmaximum);
									break;

								}
							}
							$categorycounter++;
						}
					}
					*/

					$linksettings = preg_split('/\r\n|[\r\n]/', $getdatasettings->linkscustomkeywords);

					foreach($linksettings as $linksettingrow)
					{
						$linksetting = preg_split('/,/', $linksettingrow);
						$trimmedlinksetting = array_map('trim', $linksetting);
						$linkurl = array_pop($trimmedlinksetting);

						foreach($trimmedlinksetting as $keyword)
						{
							$url = "<a href='$linkurl' target='_blank'>" . $keyword . "</a>";
							//$content = str_ireplace($keyword,$url,$content, $linksmaximum);
							$content = preg_replace("/$keyword/i",$url,$content,$linksmaximum);
						}
					}
				}
			}

			$youtubevideo = get_post_meta($post->ID, "seozen_youtubevideo", true);

			if($post->post_parent == 0)
			{
				$affiliatelink = get_post_meta($post->ID,"seozen_siloaffiliatelink", true);
			}
			else
			{
				$affiliatelink = get_post_meta($post->post_parent,"seozen_siloaffiliatelink", true);
			}

			$newaffiliatelink = "<div style='text-align: center; font-weight: bold;'><a href='$affiliatelink' target='_blank'>Click Here For More Info</a></div>";

			if(!empty($youtubevideo))
			{
				$content .= $youtubevideo;
			}

			if(!empty($affiliatelink))
			{
				$content .= $newaffiliatelink;
			}

			if($post->post_type == "page")
			{
				if($post->post_parent == 0)
				{
				}
				else
				{
					$linked = false;
					
					$args 	= array(
						"orderby" => "ID",
						"order" => "desc",
						"hierarchical" => false,
						"post_parent" => $post->post_parent,
						"post_type" => "page"

					);

					$pages = get_posts($args);

					if(is_array($pages) && count($pages) > 0)
					{
						foreach($pages as $nextpage)
						{
							if($nextpage->ID < $post->ID)
							{
								$linked = true;
								$content .= "<p><a href='" . get_permalink($nextpage->ID) . "'>" . $nextpage->post_title . "</a></p>";
								break;
							}
						}
						
					}

					if(!$linked)
					{
						$nextpage = get_post($post->post_parent);
						$content .= "<p><a href='" . get_permalink($nextpage->ID) . "'>" . $nextpage->post_title . "</a></p>";
					}

				}
			}
			else
			{
				if($post->post_parent == 0)
				{
				}
				else
				{
					$linked = false;
					
					/*
					$args = array(
						"orderby" => "ID",
						"order" => "desc",
						"hierarchical" => false,
						"post_parent" => $post->post_parent,
						"post_type" => "post"
					);

					$pages = get_posts($args);

					if(is_array($pages) && count($pages) > 0)
					{
						foreach($pages as $nextpage)
						{
							if($nextpage->ID < $post->ID)
							{
								$linked = true;
								$content .= "<p><a href='" . get_permalink($nextpage->ID) . "'>" . $nextpage->post_title . "</a></p>";
								break;
							}
						}
						
					}*/

					if(!$linked)
					{
						$nextpage = get_post($post->post_parent);
						$content .= "<p><a href='" . get_permalink($nextpage->ID) . "'>" . $nextpage->post_title . "</a></p>";
					}

				}
			}

			$content .= <<<EOD
			<style type="text/css">
			.entry-content iframe
			{
				margin-bottom: 0px !important;
			}
			</style>
EOD;
			
			$socmedbutton		= '';
			if($getdatasettings->socialfb == 'on'){
				$socmedbutton	.= <<<FACEBOOK
<li><div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1&appId=$socialfbappid";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>
<div class="fb-like" data-width="80" data-layout="button_count" data-show-faces="false" data-send="false"></div></li>
FACEBOOK;
			}

			if($getdatasettings->socialtwitter == 'on'){
				$socmedbutton	.= <<<TWITTER
<li><a href="https://twitter.com/share" class="twitter-share-button" >Tweet</a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script></li>
TWITTER;
			}

			if($getdatasettings->socialgoogle == 'on'){
				$socmedbutton	.= <<<PLUSONE
<li><div class="g-plusone" data-size="medium" data-annotation="none"></div>
<script type="text/javascript">
  (function() {
    var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
    po.src = 'https://apis.google.com/js/plusone.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
  })();
</script></li>
PLUSONE;
			}

			if($getdatasettings->socialpinterest == 'on'){
				$socmedbutton	.= <<<PINTEREST
<li><a href="//pinterest.com/pin/create/button/" data-pin-do="buttonBookmark" ><img src="//assets.pinterest.com/images/pidgets/pin_it_button.png" /></a>
<script type="text/javascript" src="//assets.pinterest.com/js/pinit.js"></script></li>
PINTEREST;
			}

			return $content.'<ul class="rankershareLinks">'.$socmedbutton.'</ul>';
		}
	}
}
new Ranker();
?>