<?php
if(!class_exists('RankerRssUrlTableClass'))
{
	class RankerRssUrlTableClass extends WP_List_Table
	{
		function ranker_rssurl_get_data()
		{
			global $wpdb;
		
			$table 	= $wpdb->prefix . 'seozen_rss';
			if(empty($_POST['s']))
			{
				$q		= "SELECT * FROM $table";
				$orderby 	= !empty($_GET["orderby"]) ? mysql_real_escape_string($_GET["orderby"]) : 'date';
				$order 	= !empty($_GET["order"]) ? mysql_real_escape_string($_GET["order"]) : 'DESC';
				if(!empty($orderby) & !empty($order)){ $q.=' ORDER BY '.$orderby.' '.$order; }
				$r		= $wpdb->get_results($q, ARRAY_A);
				
				return $r;
			}
			else
			{
				$search 	= $_POST['s'];
				$q		= "SELECT * FROM $table WHERE rssurl LIKE '%$search%'";
				$r		= $wpdb->get_results($q, ARRAY_A);
				
				return $r;
			}
		}
		
		function __construct( $args = array() )
		{
	        $args = wp_parse_args( $args, array(
	            'plural' 	=> 'rssurl',
	            'singular' 	=> 'rssurls',
	            'ajax' 		=> true
	        ) );

	        $screen = get_current_screen();

	        add_filter( "manage_{$screen->id}_columns", array( &$this, 'get_columns' ), 0 );

	        if ( !$args['plural'] )
	            $args['plural'] = $screen->base;

	        $args['plural'] 	= sanitize_key( $args['plural'] );
	        $args['singular'] 	= sanitize_key( $args['singular'] );

	        $this->_args = $args;

	        if ( $args['ajax'] ) {
	            // wp_enqueue_script( 'list-table' );
	            add_action( 'admin_footer', array( &$this, '_js_vars' ) );
	        }
	    }

	    function ajax_user_can()
	    {
			return current_user_can('manage_options');
		}
		
		function get_columns()
		{
			$columns = array(
				'rssurl'		=> 'RSS Url',
				'category'		=> 'Category',
				'quantity'		=> 'Quantity',
				'date'			=> 'Date'
			);
			
			return $columns;
		}
		
		function get_sortable_columns()
		{
			$sortable_columns = array(
				'rssurl'		=> array('rssurl', false),
				'category'		=> array('category', false),
				'quantity'		=> array('quantity', false),
				'date'			=> array('date', false)
			);
			
			return $sortable_columns;
		}
		
		function column_default($item, $column_name)
		{
			switch($column_name)
			{
				case 'rssurl':
				case 'category':
				case 'quantity':
				case 'date':
					return $item[$column_name];
				default:
					return print_r($item, true);
			}
		}
		
		function column_rssurl($item)
		{
			$actions = array(
				'delete'    => sprintf('<a onclick="return rk_deleterssurl_confirm()" href="?page=%s&action=deleterssurl&id=%d">Delete</a>', $_REQUEST['page'], $item['id'])
			);

			return sprintf('%1$s %2$s', $item['rssurl'], $this->row_actions($actions) );
		}		
		
		function prepare_items()
		{
			$columns 			= $this->get_columns();
			$hidden  			= array();
			$sortable 			= $this->get_sortable_columns();
			$this->_column_headers 	= array($columns, $hidden, $sortable);
			$per_page 			= 10;
			$current_page 		= $this->get_pagenum();
			$total_items 			= count($this->ranker_rssurl_get_data());
			$this->found_data_post 	= array_slice($this->ranker_rssurl_get_data(),(($current_page-1)*$per_page),$per_page);
			$this->set_pagination_args( array(
				'total_items' 	=> $total_items, 
				'per_page'    	=> $per_page
			));
			$this->items = $this->found_data_post;
		}

		function _js_vars()
		{
	        $current_screen = get_current_screen();

	        $args = array(
	            'class'  => get_class( $this ),
	            'screen' => array(
	                'id'   => $current_screen->id,
	                'base' => $current_screen->base,
	            )
	        );

	        printf( "<script type='text/javascript'>list_args = %s;</script>\n", json_encode( $args ) );
	    }

		function ajax_response()
		{

		}
	}
}
?>